/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.voxelmap;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.hooks.ProspectingNotificationEvent;
import com.sinthoras.visualprospecting.integration.voxelmap.IWaypointManagerReflection;
import com.thevoxelbox.voxelmap.interfaces.AbstractVoxelMap;
import com.thevoxelbox.voxelmap.interfaces.IWaypointManager;
import com.thevoxelbox.voxelmap.util.Waypoint;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.GregTech_API;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class VoxelMapEventHandler {
    @SubscribeEvent
    public void onVeinProspected(ProspectingNotificationEvent.OreVein event) {
        if (event.isCanceled()) {
            return;
        }
        OreVeinPosition pos = event.getPosition();
        IWaypointManager waypointManager = AbstractVoxelMap.getInstance().getWaypointManager();
        short[] color = GregTech_API.sGeneratedMaterials[pos.veinType.primaryOreMeta].getRGBA();
        TreeSet<Integer> dim = new TreeSet<Integer>();
        dim.add(pos.dimensionId);
        waypointManager.addWaypoint(new Waypoint(StatCollector.func_74838_a((String)pos.veinType.name), pos.getBlockX(), pos.getBlockZ(), VoxelMapEventHandler.getY(), Config.enableVoxelMapWaypointsByDefault, (float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, "Pickaxe", IWaypointManagerReflection.getCurrentSubworldDescriptor(waypointManager, false), dim));
    }

    @SubscribeEvent
    public void onFluidProspected(ProspectingNotificationEvent.UndergroundFluid event) {
        if (event.isCanceled()) {
            return;
        }
        UndergroundFluidPosition pos = event.getPosition();
        IWaypointManager waypointManager = AbstractVoxelMap.getInstance().getWaypointManager();
        int x = Utils.coordChunkToBlock(pos.chunkX);
        int z = Utils.coordChunkToBlock(pos.chunkZ);
        int color = pos.fluid.getColor();
        TreeSet<Integer> dim = new TreeSet<Integer>();
        dim.add(pos.dimensionId);
        waypointManager.addWaypoint(new Waypoint(pos.fluid.getLocalizedName(), x, z, Minecraft.func_71410_x().field_71441_e.func_72976_f(x, z), Config.enableVoxelMapWaypointsByDefault, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, "Science", IWaypointManagerReflection.getCurrentSubworldDescriptor(waypointManager, false), dim));
    }

    private static int getY() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || !heldItem.func_77977_a().contains("gt.detrav.metatool.01")) {
            return (int)player.field_70163_u;
        }
        return 65;
    }
}

