/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers;

import com.sinthoras.visualprospecting.integration.model.SupportedMods;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.RenderStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LayerRenderer
extends com.sinthoras.visualprospecting.integration.model.layers.LayerRenderer {
    private final LayerManager manager;
    protected List<RenderStep> renderSteps = new ArrayList<RenderStep>();
    protected List<RenderStep> renderStepsReversed = new ArrayList<RenderStep>();

    public LayerRenderer(LayerManager manager) {
        super(manager, SupportedMods.XaeroWorldMap);
        this.manager = manager;
    }

    public List<RenderStep> getRenderSteps() {
        return this.renderSteps;
    }

    public List<RenderStep> getRenderStepsReversed() {
        return this.renderStepsReversed;
    }

    public boolean isLayerActive() {
        return this.manager.isLayerActive();
    }

    @Override
    public void updateVisibleElements(List<? extends ILocationProvider> visibleElements) {
        this.renderSteps = this.generateRenderSteps(visibleElements);
        this.renderStepsReversed = new ArrayList<RenderStep>(this.renderSteps);
        Collections.reverse(this.renderStepsReversed);
    }

    protected abstract List<? extends RenderStep> generateRenderSteps(List<? extends ILocationProvider> var1);
}

