/*
 * Decompiled with CFR 0.152.
 */
package advsolar.common.tiles;

import advsolar.common.AdvancedSolarPanel;
import advsolar.common.container.ContainerQGenerator;
import advsolar.common.tiles.TileEntityBase;
import advsolar.network.IHasButton;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityQGenerator
extends TileEntityBase
implements IEnergyTile,
IWrenchable,
IEnergySource,
IHasButton {
    public static Random randomizer = new Random();
    public int ticker;
    private int machineTire;
    public int production;
    public boolean initialized = false;
    private short facing = (short)2;
    public boolean addedToEnergyNet;
    private boolean created = false;
    public boolean active;
    public boolean lastState = false;
    public int maxPacketSize;
    private int lastX;
    private int lastY;
    private int lastZ;
    public boolean loaded = false;
    private static List<String> fields = Arrays.asList(new String[0]);

    public TileEntityQGenerator() {
        this.production = AdvancedSolarPanel.qgbaseProduction;
        this.maxPacketSize = AdvancedSolarPanel.qgbaseMaxPacketSize;
        this.ticker = randomizer.nextInt(this.tickRate());
        this.lastX = this.field_145851_c;
        this.lastY = this.field_145848_d;
        this.lastZ = this.field_145849_e;
        this.machineTire = Integer.MAX_VALUE;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || !this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onUnloaded() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145849_e || this.lastY != this.field_145848_d) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.onLoaded();
        }
    }

    @Override
    public boolean getActive() {
        this.active = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.active != this.lastState) {
            this.lastState = this.active;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.active;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.production = nbttagcompound.func_74762_e("production");
        this.maxPacketSize = nbttagcompound.func_74762_e("maxPacketSize");
        this.lastX = nbttagcompound.func_74762_e("lastX");
        this.lastY = nbttagcompound.func_74762_e("lastY");
        this.lastZ = nbttagcompound.func_74762_e("lastZ");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        nbttagcompound.func_74768_a("production", this.production);
        nbttagcompound.func_74768_a("maxPacketSize", this.maxPacketSize);
        nbttagcompound.func_74768_a("lastX", this.lastX);
        nbttagcompound.func_74768_a("lastY", this.lastY);
        nbttagcompound.func_74768_a("lastZ", this.lastZ);
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityplayer, int i) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public List<String> getNetworkedFields() {
        return fields;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerQGenerator(inventoryplayer, this);
    }

    public String getInvName() {
        return "QuantumGenerator";
    }

    public void changeProductionOutput(int value) {
        this.production += value;
        if (this.production < 1) {
            this.production = 1;
        }
    }

    public void changeMaxPacketSize(int value) {
        this.maxPacketSize += value;
        if (this.maxPacketSize < 1) {
            this.maxPacketSize = 1;
        }
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        this.getActive();
        if (!this.active) {
            return this.production;
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
    }

    @Override
    public void handleButtonClick(int event) {
        switch (event) {
            case 1: {
                this.changeProductionOutput(-100);
                break;
            }
            case 2: {
                this.changeProductionOutput(-10);
                break;
            }
            case 3: {
                this.changeProductionOutput(-1);
                break;
            }
            case 4: {
                this.changeProductionOutput(1);
                break;
            }
            case 5: {
                this.changeProductionOutput(10);
                break;
            }
            case 6: {
                this.changeProductionOutput(100);
                break;
            }
            case 7: {
                this.changeMaxPacketSize(-100);
                break;
            }
            case 8: {
                this.changeMaxPacketSize(-10);
                break;
            }
            case 9: {
                this.changeMaxPacketSize(-1);
                break;
            }
            case 10: {
                this.changeMaxPacketSize(1);
                break;
            }
            case 11: {
                this.changeMaxPacketSize(10);
                break;
            }
            case 12: {
                this.changeMaxPacketSize(100);
                break;
            }
            case 101: {
                this.changeProductionOutput(-1000);
                break;
            }
            case 102: {
                this.changeProductionOutput(-100);
                break;
            }
            case 103: {
                this.changeProductionOutput(-10);
                break;
            }
            case 104: {
                this.changeProductionOutput(10);
                break;
            }
            case 105: {
                this.changeProductionOutput(100);
                break;
            }
            case 106: {
                this.changeProductionOutput(1000);
                break;
            }
            case 107: {
                this.changeMaxPacketSize(-1000);
                break;
            }
            case 108: {
                this.changeMaxPacketSize(-100);
                break;
            }
            case 109: {
                this.changeMaxPacketSize(-10);
                break;
            }
            case 110: {
                this.changeMaxPacketSize(10);
                break;
            }
            case 111: {
                this.changeMaxPacketSize(100);
                break;
            }
            case 112: {
                this.changeMaxPacketSize(1000);
            }
        }
    }

    public int getSourceTier() {
        return this.machineTire;
    }
}

