/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.items.tool;

import com.arc.bloodarsenal.common.items.tool.InfusedDiamondAxe;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ToolCapabilities {
    public static Material[] materialsPick = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g};
    public static Material[] materialsShovel = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    public static Material[] materialsAxe = new Material[]{Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d};
    public static int lastx = 0;
    public static int lasty = 0;
    public static int lastz = 0;
    public static double lastdistance = 0.0;

    public static int getMode(ItemStack tool) {
        return tool.func_77960_j();
    }

    public static int getNextMode(int mode) {
        return mode == 2 ? 0 : mode + 1;
    }

    public static void changeMode(ItemStack tool) {
        int mode = ToolCapabilities.getMode(tool);
        tool.func_77964_b(ToolCapabilities.getNextMode(mode));
    }

    public static boolean isRightMaterial(Material material, Material[] materialsListing) {
        for (Material mat : materialsListing) {
            if (material != mat) continue;
            return true;
        }
        return false;
    }

    public static void removeBlocksInIteration(EntityPlayer player, World world, int x, int y, int z, int xs, int ys, int zs, int xe, int ye, int ze, Block block, Material[] materialsListing) {
        float blockHardness = block == null ? 1.0f : block.func_149712_f(world, x, y, z);
        for (int x1 = xs; x1 < xe; ++x1) {
            for (int y1 = ys; y1 < ye; ++y1) {
                for (int z1 = zs; z1 < ze; ++z1) {
                    ToolCapabilities.removeBlockWithDrops(player, world, x1 + x, y1 + y, z1 + z, x, y, z, block, materialsListing);
                }
            }
        }
    }

    public static void removeBlockWithDrops(EntityPlayer player, World world, int x, int y, int z, int bx, int by, int bz, Block block, Material[] materialsListing) {
        if (!world.func_72899_e(x, y, z)) {
            return;
        }
        Block blk = world.func_147439_a(x, y, z);
        if (block != null && blk != block) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        Material mat = world.func_147439_a(x, y, z).func_149688_o();
        if (blk != null && !blk.isAir((IBlockAccess)world, x, y, z) && blk.func_149737_a(player, world, x, y, z) != 0.0f) {
            if (!blk.canHarvestBlock(player, meta) || !ToolCapabilities.isRightMaterial(mat, materialsListing)) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                int localMeta = world.func_72805_g(x, y, z);
                if (blk.removedByPlayer(world, player, x, y, z)) {
                    blk.func_149664_b(world, x, y, z, localMeta);
                }
                blk.func_149636_a(world, player, x, y, z, localMeta);
                blk.func_149681_a(world, x, y, z, localMeta, player);
            } else {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public static boolean isWood(IBlockAccess world, int x, int y, int z) {
        Block blk = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (blk == Blocks.field_150350_a) {
            return false;
        }
        if (blk.canSustainLeaves(world, x, y, z)) {
            return true;
        }
        return InfusedDiamondAxe.oreDictLogs.contains(Arrays.asList(blk, metadata));
    }

    public static boolean breakFurthestBlock(World world, int x, int y, int z, Block block, EntityPlayer player) {
        lastx = x;
        lasty = y;
        lastz = z;
        lastdistance = 0.0;
        ToolCapabilities.findBlocks(world, x, y, z, block);
        boolean worked = ToolCapabilities.harvestBlock(world, player, lastx, lasty, lastz);
        if (worked) {
            for (int xx = -3; xx <= 3; ++xx) {
                for (int yy = -3; yy <= 3; ++yy) {
                    for (int zz = -3; zz <= 3; ++zz) {
                        world.func_147464_a(lastx + xx, lasty + yy, lastz + zz, world.func_147439_a(lastx + xx, lasty + yy, lastz + zz), 150 + world.field_73012_v.nextInt(150));
                    }
                }
            }
        }
        return worked;
    }

    public static void findBlocks(World world, int x, int y, int z, Block block) {
        for (int xx = -2; xx <= 2; ++xx) {
            for (int yy = 2; yy >= -2; --yy) {
                for (int zz = -2; zz <= 2; ++zz) {
                    double zd;
                    double yd;
                    double xd;
                    double d;
                    if (Math.abs(lastx + xx - x) > 24) {
                        return;
                    }
                    if (Math.abs(lasty + yy - y) > 48) {
                        return;
                    }
                    if (Math.abs(lastz + zz - z) > 24) {
                        return;
                    }
                    if (world.func_147439_a(lastx + xx, lasty + yy, lastz + zz) != block || !ToolCapabilities.isWood((IBlockAccess)world, lastx + xx, lasty + yy, lastz + zz) || !(block.func_149712_f(world, lastx + xx, lasty + yy, lastz + zz) >= 0.0f) || !((d = (xd = (double)(lastx + xx - x)) * xd + (yd = (double)(lasty + yy - y)) * yd + (zd = (double)(lastz + zz - z)) * zd) > lastdistance)) continue;
                    lastdistance = d;
                    lastx += xx;
                    lasty += yy;
                    lastz += zz;
                    ToolCapabilities.findBlocks(world, x, y, z, block);
                    return;
                }
            }
        }
    }

    public static boolean harvestBlock(World world, EntityPlayer player, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (metadata << 12));
        boolean flag = false;
        if (player.field_71075_bZ.field_75098_d) {
            flag = ToolCapabilities.removeBlock(world, x, y, z, player);
        } else {
            boolean flag1 = false;
            if (block != null) {
                flag1 = block.canHarvestBlock(player, metadata);
            }
            if ((flag = ToolCapabilities.removeBlock(world, x, y, z, player)) && flag1) {
                block.func_149636_a(world, player, x, y, z, metadata);
            }
        }
        return true;
    }

    private static boolean removeBlock(World world, int par1, int par2, int par3, EntityPlayer player) {
        boolean flag;
        Block block = world.func_147439_a(par1, par2, par3);
        int metadata = world.func_72805_g(par1, par2, par3);
        if (block != null) {
            block.func_149681_a(world, par1, par2, par3, metadata, player);
        }
        boolean bl = flag = block != null && block.removedByPlayer(world, player, par1, par2, par3);
        if (block != null && flag) {
            block.func_149664_b(world, par1, par2, par3, metadata);
        }
        return flag;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72901_a(vec3, vec31, par3);
    }
}

