/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.RegistrySocial;
import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandHand
implements ISubCommand {
    public static ISubCommand instance = new CommandHand();
    private static HashMap<String, InfoType> infoMap = new HashMap();

    @Override
    public String getCommandName() {
        return "hand";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        EntityPlayerMP entityPlayerMP = null;
        ItemStack itemStack = null;
        switch (n) {
            case 0: {
                iCommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
            default: {
                try {
                    entityPlayerMP = CommandBase.func_82359_c((ICommandSender)iCommandSender, (String)stringArray[++n2]);
                }
                catch (CommandException commandException) {
                    if (!infoMap.containsKey(stringArray[n2])) {
                        throw commandException;
                    }
                    --n2;
                }
                if (entityPlayerMP == null || entityPlayerMP == iCommandSender || CommandHandler.canUseCommand(iCommandSender, 1, this.getCommandName()) || RegistrySocial.playerHasAccess(iCommandSender.func_70005_c_(), entityPlayerMP.func_146103_bH())) break;
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            case 1: 
        }
        if (entityPlayerMP == null) {
            entityPlayerMP = CommandBase.func_71521_c((ICommandSender)iCommandSender);
        }
        if ((itemStack = entityPlayerMP.func_71045_bC()) == null) {
            iCommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.enchant.noItem", new Object[0]));
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (++n2 == n) {
            arrayList.add((Object)InfoType.Name);
        } else {
            while (n2 < n) {
                Object object = infoMap.get(stringArray[n2].toLowerCase());
                if (object == null) {
                    iCommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                    throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
                }
                arrayList.add(object);
                ++n2;
            }
        }
        for (InfoType infoType : arrayList) {
            IChatComponent[] iChatComponentArray = infoType.getData(itemStack);
            ChatComponentText chatComponentText = new ChatComponentText(infoType.name() + ": ");
            if (iChatComponentArray.length >= 1 && iChatComponentArray[0] != null) {
                chatComponentText.func_150257_a(iChatComponentArray[0]);
            }
            iCommandSender.func_145747_a((IChatComponent)chatComponentText);
            for (n2 = 1; n2 < iChatComponentArray.length; ++n2) {
                iCommandSender.func_145747_a(iChatComponentArray[n2]);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.func_71530_a((String[])stringArray, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        return CommandBase.func_71531_a((String[])stringArray, infoMap.keySet());
    }

    static {
        InfoType.values();
    }

    private static enum InfoType {
        Name(new String[]{"generic"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                ChatComponentText chatComponentText = new ChatComponentText("");
                chatComponentText.func_150257_a(itemStack.func_151000_E());
                if (itemStack.func_82837_s()) {
                    String string = itemStack.func_77973_b().func_77667_c(itemStack);
                    if (!StatCollector.func_94522_b((String)string)) {
                        string = string + ".name";
                    }
                    ChatComponentTranslation chatComponentTranslation = new ChatComponentTranslation(string, new Object[0]);
                    chatComponentTranslation.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(string)));
                    chatComponentText.func_150258_a(" (").func_150257_a((IChatComponent)chatComponentTranslation).func_150258_a(")");
                }
                return chatComponentText;
            }
        }
        ,
        Id{

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()));
            }
        }
        ,
        Size(new String[]{"amount", "count"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(String.valueOf(itemStack.field_77994_a));
            }
        }
        ,
        Metadata(new String[]{"damage", "alt"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(String.valueOf(ItemHelper.getItemDamage(itemStack)));
            }
        }
        ,
        toString(new String[]{"string", "text"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(itemStack.toString());
            }
        }
        ,
        Action(new String[]{"use"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                EnumAction enumAction = itemStack.func_77975_n();
                ChatComponentText chatComponentText = new ChatComponentText(enumAction.name());
                if (enumAction != EnumAction.none) {
                    chatComponentText.func_150258_a(" | Duration: " + itemStack.func_77988_m());
                }
                return chatComponentText;
            }
        }
        ,
        Lore(new String[]{"flavorText"}){

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                if (itemStack.func_77942_o() && itemStack.field_77990_d.func_150297_b("display", 10)) {
                    NBTTagList nBTTagList;
                    NBTTagCompound nBTTagCompound = itemStack.field_77990_d.func_74775_l("display");
                    if (nBTTagCompound.func_150299_b("Lore") == 9 && (nBTTagList = nBTTagCompound.func_150295_c("Lore", 8)).func_74745_c() > 0) {
                        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                            linkedList.add(new ChatComponentText("\u00a75      \u00a7o" + nBTTagList.func_150307_f(i)));
                        }
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        }
        ,
        Enchants(new String[]{"enchant", "ench"}){

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                NBTTagList nBTTagList = itemStack.func_77986_q();
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                if (nBTTagList != null && nBTTagList.func_74745_c() > 0) {
                    for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                        short s = nBTTagList.func_150305_b(i).func_74765_d("id");
                        short s2 = nBTTagList.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.field_77331_b[s] != null) {
                            linkedList.add(new ChatComponentText("\u00a73     " + StatCollector.func_74838_a((String)Enchantment.field_77331_b[s].func_77320_a()) + " " + StringHelper.toNumerals(s2)));
                            continue;
                        }
                        linkedList.add(new ChatComponentText("\u00a74     " + String.format("Invalid{id=%s,lvl=%s}", s, s2)));
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        }
        ,
        NBT(new String[]{"tag", "stackTag", "compoundTag"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(Objects.toString(itemStack.func_77978_p(), "null"));
            }
        }
        ,
        OreDict(new String[]{"oreNames", "oreName", "ores", "ore"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                ArrayList<String> arrayList = OreDictionaryArbiter.getAllOreNames(itemStack);
                int n = arrayList == null ? 0 : arrayList.size();
                String string = Objects.toString(arrayList, "[null]");
                return new ChatComponentText(n + "> " + string.substring(1, string.length() - 1));
            }
        }
        ,
        Modifiers{
            protected final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                Multimap multimap = itemStack.func_111283_C();
                if (!multimap.isEmpty()) {
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                        double d = attributeModifier.func_111164_d();
                        if (this.field_111210_e.equals(attributeModifier.func_111167_a())) {
                            d += (double)EnchantmentHelper.func_152377_a((ItemStack)itemStack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                        }
                        double d2 = attributeModifier.func_111169_c() != 1 && attributeModifier.func_111169_c() != 2 ? d : d * 100.0;
                        if (d > 0.0) {
                            linkedList.add(new ChatComponentText("     \u00a79" + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributeModifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d2), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))})));
                            continue;
                        }
                        if (!(d < 0.0)) continue;
                        d2 = -d2;
                        linkedList.add(new ChatComponentText("     \u00a7c" + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributeModifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d2), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))})));
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        };


        private InfoType() {
            infoMap.put(this.name().toLowerCase(), this);
        }

        private InfoType(String ... stringArray) {
            this();
            for (String string2 : stringArray) {
                infoMap.put(string2.toLowerCase(), this);
            }
        }

        public IChatComponent processStack(ItemStack itemStack) {
            return null;
        }

        public IChatComponent[] getData(ItemStack itemStack) {
            return new IChatComponent[]{this.processStack(itemStack)};
        }
    }
}

