/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.cc.TurtlePeripheralBase;
import pl.asie.computronics.cc.TurtleUpgradeBase;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.ChatBoxUtils;

public class SpeakingTurtleUpgrade
extends TurtleUpgradeBase {
    public SpeakingTurtleUpgrade(int id) {
        super(id);
    }

    public String getUnlocalisedAdjective() {
        return "Speaking";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)Computronics.chatBox, 1, 0);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new SpeakingTurtlePeripheral(turtle);
    }

    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return Computronics.chatBox.func_149691_a(2, 0);
    }

    private static class SpeakingTurtlePeripheral
    extends TurtlePeripheralBase {
        public SpeakingTurtlePeripheral(ITurtleAccess access) {
            super(access);
        }

        public String getType() {
            return "chat_box";
        }

        @Optional.Method(modid="ComputerCraft")
        public String[] getMethodNames() {
            return new String[]{"say"};
        }

        @Optional.Method(modid="ComputerCraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            if (arguments.length == 0 || !(arguments[0] instanceof String)) {
                return null;
            }
            int distance = Config.CHATBOX_DISTANCE;
            if (arguments.length > 1 && arguments[1] instanceof Double && (distance = Math.min(Config.CHATBOX_DISTANCE, ((Double)arguments[1]).intValue())) <= 0) {
                distance = Config.CHATBOX_DISTANCE;
            }
            String prefix = Config.CHATBOX_PREFIX;
            ChatBoxUtils.sendChatMessage(this.access.getWorld(), this.access.getPosition().field_71574_a, this.access.getPosition().field_71572_b, this.access.getPosition().field_71573_c, distance, prefix, (String)arguments[0]);
            return null;
        }
    }
}

