/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Serializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.SerializerFactory;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.minlog.Log;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.ClosureSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.Generics;

public class Util {
    public static final boolean isAndroid;
    public static final boolean unsafe;
    public static final int maxArraySize = 0x7FFFFFF7;
    private static final Map<Class<?>, Class<?>> primitiveWrappers;

    public static boolean isUnsafeAvailable() {
        return unsafe;
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            Log.debug("kryo", "Class not available: " + className);
            return false;
        }
    }

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return type;
    }

    public static Class getPrimitiveClass(Class type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Void.class) {
            return Void.TYPE;
        }
        return type;
    }

    public static Class getArrayType(Class type) {
        if (type == String.class) {
            return String[].class;
        }
        if (type == Integer.class) {
            return Integer[].class;
        }
        if (type == Float.class) {
            return Float[].class;
        }
        if (type == Boolean.class) {
            return Boolean[].class;
        }
        if (type == Byte.class) {
            return Byte[].class;
        }
        if (type == Long.class) {
            return Long[].class;
        }
        if (type == Character.class) {
            return Character[].class;
        }
        if (type == Double.class) {
            return Double[].class;
        }
        if (type == Short.class) {
            return Short[].class;
        }
        return Array.newInstance(type, 0).getClass();
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Byte.class || type == Long.class || type == Character.class || type == Double.class || type == Short.class;
    }

    public static boolean isEnum(Class type) {
        return Enum.class.isAssignableFrom(type) && type != Enum.class;
    }

    public static void log(String message, Object object, int position) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null" + Util.pos(position));
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || Util.isWrapperClass(type) || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object) + Util.pos(position));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object) + Util.pos(position));
        }
    }

    public static String pos(int position) {
        return position == -1 ? "" : " [" + position + "]";
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        String className = Log.TRACE ? Util.className(type) : type.getSimpleName();
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return className;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String value = String.valueOf(object) + " (" + className + ")";
            return value.length() > 97 ? value.substring(0, 97) + "..." : value;
        }
        catch (Throwable ex) {
            return className + " (toString exception: " + ex + ")";
        }
    }

    public static String className(Class type) {
        if (type == null) {
            return "null";
        }
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static String classNames(Class[] types) {
        StringBuilder buffer = new StringBuilder(32);
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(Util.className(types[i]));
        }
        return buffer.toString();
    }

    public static String canonicalName(Class type) {
        if (type == null) {
            return "null";
        }
        String canonicalName = type.getCanonicalName();
        return canonicalName != null ? canonicalName : Util.className(type);
    }

    public static String simpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    public static String simpleName(Class type, Generics.GenericType genericType) {
        int i;
        int n;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append((type.isArray() ? Util.getElementClass(type) : type).getSimpleName());
        if (genericType.arguments != null) {
            buffer.append('<');
            n = genericType.arguments.length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(genericType.arguments[i].toString());
            }
            buffer.append('>');
        }
        if (type.isArray()) {
            n = Util.getDimensionCount(type);
            for (i = 0; i < n; ++i) {
                buffer.append("[]");
            }
        }
        return buffer.toString();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static boolean isAssignableTo(Class<?> from, Class<?> to) {
        if (to == Object.class) {
            return true;
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            return Util.isPrimitiveWrapperOf(to, from) || to.isAssignableFrom(Util.getPrimitiveWrapper(from));
        }
        if (to.isPrimitive()) {
            return Util.isPrimitiveWrapperOf(from, to);
        }
        if (from == ClosureSerializer.Closure.class) {
            return to.isInterface();
        }
        return false;
    }

    private static boolean isPrimitiveWrapperOf(Class<?> targetClass, Class<?> primitive) {
        return Util.getPrimitiveWrapper(primitive) == targetClass;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            throw new IllegalArgumentException("Argument has to be primitive type");
        }
        return primitiveWrappers.get(primitive);
    }

    public static boolean isAscii(String value) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (value.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static <T extends SerializerFactory> T newFactory(Class<T> factoryClass, Class<? extends Serializer> serializerClass) {
        try {
            if (serializerClass != null) {
                try {
                    return (T)((SerializerFactory)factoryClass.getConstructor(Class.class).newInstance(serializerClass));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (T)((SerializerFactory)factoryClass.newInstance());
        }
        catch (Exception ex) {
            if (serializerClass == null) {
                throw new IllegalArgumentException("Unable to create serializer factory: " + factoryClass.getName(), ex);
            }
            throw new IllegalArgumentException("Unable to create serializer factory \"" + factoryClass.getName() + "\" for serializer class: " + Util.className(serializerClass), ex);
        }
    }

    static {
        boolean found;
        block5: {
            isAndroid = "Dalvik".equals(System.getProperty("java.vm.name"));
            found = false;
            if ("false".equals(System.getProperty("kryo.unsafe"))) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Unsafe is disabled.");
                }
            } else {
                try {
                    found = Class.forName("makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil", true, FieldSerializer.class.getClassLoader()).getField("unsafe").get(null) != null;
                }
                catch (Throwable ex) {
                    if (!Log.TRACE) break block5;
                    Log.trace("kryo", "Unsafe is unavailable.", ex);
                }
            }
        }
        unsafe = found;
        primitiveWrappers = new HashMap();
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
    }
}

