/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.IOUtils;

public class RecipeConfig {
    private boolean dumpItemRegistery = false;
    private boolean dumpOreDictionary = false;
    private boolean enabled = true;
    private Map<String, RecipeGroup> recipeGroups = new HashMap<String, RecipeGroup>();

    public static RecipeConfig loadRecipeConfig(String coreFileName, String customFileName, CustomTagHandler customHandler) {
        RecipeConfig config;
        File coreFile = new File(Config.configDirectory, coreFileName);
        String defaultVals = null;
        try {
            defaultVals = RecipeConfig.readRecipes(coreFile, coreFileName, true);
        }
        catch (IOException e) {
            Log.error("Could not load default recipes file " + coreFile + " from EnderIO jar: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        if (!coreFile.exists()) {
            Log.error("Could not load default recipes from " + coreFile + " as the file does not exist.");
            return null;
        }
        try {
            config = RecipeConfigParser.parse(defaultVals, customHandler);
        }
        catch (Exception e) {
            Log.error("Error parsing " + coreFileName);
            return null;
        }
        File userFile = new File(Config.configDirectory, customFileName);
        String userConfigStr = null;
        try {
            userConfigStr = RecipeConfig.readRecipes(userFile, customFileName, false);
            if (userConfigStr == null || userConfigStr.trim().length() == 0) {
                Log.error("Empty user config file: " + userFile.getAbsolutePath());
            } else {
                RecipeConfig userConfig = RecipeConfigParser.parse(userConfigStr, customHandler);
                config.merge(userConfig);
            }
        }
        catch (Exception e) {
            Log.error("Could not load user defined recipes from file: " + customFileName);
            e.printStackTrace();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRecipes(File copyTo, String fileName, boolean replaceIfExists) throws IOException {
        if (!replaceIfExists && copyTo.exists()) {
            return RecipeConfig.readStream(new FileInputStream(copyTo));
        }
        InputStream in = RecipeConfig.class.getResourceAsStream("/assets/enderio/config/" + fileName);
        if (in == null) {
            Log.error("Could load default AlloySmelter recipes.");
            throw new IOException("Could not resource /assets/enderio/config/" + fileName + " form classpath. ");
        }
        String output = RecipeConfig.readStream(in);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(copyTo, false));
            writer.write(output.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder output = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                output.append(line);
                output.append("\n");
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return output.toString();
    }

    public void merge(RecipeConfig userConfig) {
        if (userConfig.dumpItemRegistery) {
            this.dumpItemRegistery = true;
        }
        if (userConfig.dumpOreDictionary) {
            this.dumpOreDictionary = true;
        }
        for (RecipeGroup group : userConfig.getRecipeGroups().values()) {
            if (!group.enabled) {
                if (this.recipeGroups.remove(group.name) == null) continue;
                Log.debug("Disabled core recipe group " + group.name + " due to user config.");
                continue;
            }
            RecipeGroup modifyGroup = this.recipeGroups.get(group.name);
            if (modifyGroup == null) {
                Log.debug("Added user defined recipe group " + group.name);
                modifyGroup = new RecipeGroup(group.name);
                this.recipeGroups.put(group.name, modifyGroup);
            }
            for (RecipeElement recipe : group.recipes.values()) {
                if (recipe.isValid()) {
                    modifyGroup.addRecipe(recipe);
                    continue;
                }
                modifyGroup.recipes.remove(recipe.name);
            }
        }
    }

    public RecipeGroup createRecipeGroup(String name) {
        return new RecipeGroup(name);
    }

    public void addRecipeGroup(RecipeGroup group) {
        if (group.isNameValid()) {
            this.recipeGroups.put(group.getName(), group);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRecipeGroups(Map<String, RecipeGroup> recipeGroups) {
        this.recipeGroups = recipeGroups;
    }

    public boolean isDumpItemRegistery() {
        return this.dumpItemRegistery;
    }

    public void setDumpItemRegistery(boolean dumpItemRegistery) {
        this.dumpItemRegistery = dumpItemRegistery;
    }

    public boolean isDumpOreDictionary() {
        return this.dumpOreDictionary;
    }

    public void setDumpOreDictionary(boolean dumpOreDictionary) {
        this.dumpOreDictionary = dumpOreDictionary;
    }

    public List<Recipe> getRecipes(boolean isRecipePerInput) {
        ArrayList<Recipe> result = new ArrayList<Recipe>(32);
        for (RecipeGroup rg : this.recipeGroups.values()) {
            if (!rg.isEnabled() || !rg.isValid()) continue;
            result.addAll(rg.createRecipes(isRecipePerInput));
        }
        return result;
    }

    public List<Recipe> getRecipesForGroup(String group, boolean isRecipePerInput) {
        RecipeGroup grp = this.recipeGroups.get(group);
        if (grp == null) {
            return Collections.emptyList();
        }
        return grp.createRecipes(isRecipePerInput);
    }

    public Map<String, RecipeGroup> getRecipeGroups() {
        return this.recipeGroups;
    }

    public static class RecipeElement {
        private List<RecipeInput> inputs = new ArrayList<RecipeInput>();
        private List<RecipeOutput> outputs = new ArrayList<RecipeOutput>();
        private int energyRequired;
        private RecipeBonusType bonusType = RecipeBonusType.MULTIPLY_OUTPUT;
        private String name;
        private boolean allowMissing = false;
        private boolean invalidated = false;

        private RecipeElement(String name) {
            this.name = name;
        }

        public void addInput(RecipeInput input) {
            this.inputs.add(input);
        }

        public void addInput(ItemStack stack, boolean useMetadata) {
            this.inputs.add(new RecipeInput(stack, useMetadata));
        }

        public void addOutput(RecipeOutput output) {
            this.outputs.add(output);
        }

        public List<Recipe> createRecipes(boolean isRecipePerInput) {
            RecipeOutput[] outputArr = this.outputs.toArray(new RecipeOutput[this.outputs.size()]);
            RecipeInput[] inputArr = this.inputs.toArray(new RecipeInput[this.inputs.size()]);
            ArrayList<Recipe> result = new ArrayList<Recipe>();
            if (isRecipePerInput) {
                for (RecipeInput input : this.inputs) {
                    result.add(new Recipe(input, this.energyRequired, this.bonusType, outputArr));
                }
            } else {
                for (RecipeOutput output : this.outputs) {
                    result.add(new Recipe(output, this.energyRequired, this.bonusType, inputArr));
                }
            }
            return result;
        }

        public boolean isValid() {
            return !this.invalidated && !this.inputs.isEmpty() && !this.outputs.isEmpty();
        }

        public float getEnergyRequired() {
            return this.energyRequired;
        }

        public void setEnergyRequired(int energyRequired) {
            this.energyRequired = energyRequired;
        }

        public RecipeBonusType getBonusType() {
            return this.bonusType;
        }

        public void setBonusType(RecipeBonusType bonusType) {
            this.bonusType = bonusType;
        }

        public void setAllowMissing(boolean allowMissing) {
            this.allowMissing = allowMissing;
        }

        public boolean allowMissing() {
            return this.allowMissing;
        }

        public void invalidate() {
            this.invalidated = true;
        }

        public String toString() {
            return "Recipe [" + (this.invalidated ? "INVALID " : "") + "input=" + this.inputs + ", outputs=" + this.outputs + ", energyRequired=" + this.energyRequired + ", bonusType=" + (Object)((Object)this.bonusType) + "]";
        }
    }

    public static class RecipeGroup {
        private final String name;
        private Map<String, RecipeElement> recipes = new LinkedHashMap<String, RecipeElement>();
        private boolean enabled = true;

        public RecipeGroup(String name) {
            if (name != null && (name = name.trim()).length() <= 0) {
                name = null;
            }
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public RecipeElement createRecipe(String name) {
            return new RecipeElement(name);
        }

        public void addRecipe(RecipeElement recipe) {
            this.recipes.put(recipe.name, recipe);
        }

        public String getName() {
            return this.name;
        }

        public List<Recipe> createRecipes(boolean isRecipePerInput) {
            ArrayList<Recipe> result = new ArrayList<Recipe>(this.recipes.size());
            for (RecipeElement recipe : this.recipes.values()) {
                if (!recipe.isValid()) continue;
                result.addAll(recipe.createRecipes(isRecipePerInput));
            }
            return result;
        }

        public boolean isValid() {
            return this.isNameValid() && !this.recipes.isEmpty();
        }

        public boolean isNameValid() {
            return this.name != null;
        }

        public String toString() {
            return "RecipeGroup [name=" + this.name + ", recipes=" + this.recipes + ", enabled=" + this.enabled + "]";
        }
    }
}

