/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.ClientUtils;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.RenderCustomEndPortal;
import codechicken.enderstorage.internal.EnderStorageClientProxy;
import codechicken.enderstorage.storage.item.EnderDyeButton;
import codechicken.enderstorage.storage.item.ModelEnderChest;
import codechicken.enderstorage.storage.item.TileEnderChest;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class EnderChestRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation ENDERCHEST_TEXTURE = new ResourceLocation("enderstorage:textures/enderchest.png");
    private static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("enderstorage:textures/buttons.png");
    private static final ResourceLocation HEDRON_TEXTURE = new ResourceLocation("enderstorage:textures/hedronmap.png");
    private static final ModelEnderChest model = new ModelEnderChest();
    private static final Vector3 Y = new Vector3(0.0, 1.0, 0.0);
    public static final double phi = 1.618034;
    static RenderCustomEndPortal renderEndPortal = new RenderCustomEndPortal(0.626, 0.188, 0.812, 0.188, 0.812);

    public static void renderChest(CCRenderState state, int rotation, int freq, boolean owned, double x, double y, double z, int offset, float lidAngle) {
        boolean isChestOpen;
        boolean bl = isChestOpen = lidAngle < 0.0f;
        if (isChestOpen && !EnderStorage.disableFXChest) {
            renderEndPortal.renderAt(x, y, z);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CCRenderState.changeTexture((ResourceLocation)ENDERCHEST_TEXTURE);
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)(rotation * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        EnderChestRenderer.model.chestLid.field_78795_f = lidAngle;
        model.render(owned);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        CCRenderState.changeTexture((ResourceLocation)BUTTONS_TEXTURE);
        EnderChestRenderer.drawButton(0, EnderStorageManager.getColourFromFreq(freq, 0), rotation, lidAngle);
        EnderChestRenderer.drawButton(1, EnderStorageManager.getColourFromFreq(freq, 1), rotation, lidAngle);
        EnderChestRenderer.drawButton(2, EnderStorageManager.getColourFromFreq(freq, 2), rotation, lidAngle);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        if (isChestOpen) {
            double time = ClientUtils.getRenderTime() + (double)offset;
            Matrix4 pearlMat = CCModelLibrary.getRenderMatrix((double)(x + 0.5), (double)(y + 0.2 + (double)lidAngle * -0.5 + (double)EnderStorageClientProxy.getPearlBob(time)), (double)(z + 0.5), (Rotation)new Rotation(time / 3.0, Y), (double)0.04);
            GL11.glDisable((int)2896);
            CCRenderState.changeTexture((ResourceLocation)HEDRON_TEXTURE);
            state.startDrawingInstance(4);
            CCModelLibrary.icosahedron4.render(new CCRenderState.IVertexOperation[]{pearlMat});
            state.drawInstance();
            GL11.glEnable((int)2896);
        }
    }

    private static void drawButton(int button, int colour, int rot, double lidAngle) {
        float texx = 0.25f * (float)(colour % 4);
        float texy = 0.25f * (float)(colour / 4);
        GL11.glPushMatrix();
        EnderDyeButton ebutton = TileEnderChest.buttons[button].copy();
        ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, lidAngle);
        ebutton.rotateMeta(rot);
        Vector3[] verts = ebutton.verts;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        EnderChestRenderer.addVecWithUV(verts[7], (double)texx + 0.0938, (double)texy + 0.0625);
        EnderChestRenderer.addVecWithUV(verts[3], (double)texx + 0.0938, (double)texy + 0.1875);
        EnderChestRenderer.addVecWithUV(verts[2], (double)texx + 0.1562, (double)texy + 0.1875);
        EnderChestRenderer.addVecWithUV(verts[6], (double)texx + 0.1562, (double)texy + 0.0625);
        EnderChestRenderer.addVecWithUV(verts[4], (double)texx + 0.0938, (double)texy + 0.0313);
        EnderChestRenderer.addVecWithUV(verts[7], (double)texx + 0.0938, (double)texy + 0.0313);
        EnderChestRenderer.addVecWithUV(verts[6], (double)texx + 0.1562, (double)texy + 0.0624);
        EnderChestRenderer.addVecWithUV(verts[5], (double)texx + 0.1562, (double)texy + 0.0624);
        EnderChestRenderer.addVecWithUV(verts[0], (double)texx + 0.0938, (double)texy + 0.2186);
        EnderChestRenderer.addVecWithUV(verts[1], (double)texx + 0.1562, (double)texy + 0.2186);
        EnderChestRenderer.addVecWithUV(verts[2], (double)texx + 0.1562, (double)texy + 0.1876);
        EnderChestRenderer.addVecWithUV(verts[3], (double)texx + 0.0938, (double)texy + 0.1876);
        EnderChestRenderer.addVecWithUV(verts[6], (double)texx + 0.1563, (double)texy + 0.0626);
        EnderChestRenderer.addVecWithUV(verts[2], (double)texx + 0.1563, (double)texy + 0.1874);
        EnderChestRenderer.addVecWithUV(verts[1], (double)texx + 0.1874, (double)texy + 0.1874);
        EnderChestRenderer.addVecWithUV(verts[5], (double)texx + 0.1874, (double)texy + 0.0626);
        EnderChestRenderer.addVecWithUV(verts[7], (double)texx + 0.0937, (double)texy + 0.0626);
        EnderChestRenderer.addVecWithUV(verts[4], (double)texx + 0.0626, (double)texy + 0.0626);
        EnderChestRenderer.addVecWithUV(verts[0], (double)texx + 0.0626, (double)texy + 0.1874);
        EnderChestRenderer.addVecWithUV(verts[3], (double)texx + 0.0937, (double)texy + 0.1874);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private static void addVecWithUV(Vector3 vec, double u, double v) {
        Tessellator.field_78398_a.func_78374_a(vec.x, vec.y, vec.z, u, v);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        CCRenderState state = CCRenderState.instance();
        state.resetInstance();
        state.setBrightnessInstance((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        state.useNormals = true;
        TileEnderChest chest = (TileEnderChest)tile;
        EnderChestRenderer.renderChest(state, chest.rotation, chest.freq, !chest.owner.equals("global"), x, y, z, EnderStorageClientProxy.getTimeOffset(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e), chest.getRadianLidAngle(partialTicks));
    }
}

