/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.core.serializer;

import eu.usrv.enhancedlootbags.EnhancedLootBags;
import eu.usrv.enhancedlootbags.core.LootGroupsHandler;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="LootGroups")
public class LootGroups {
    @XmlElement(name="LootGroup")
    private List<LootGroup> mLootGroups;

    private void Init() {
        if (this.mLootGroups == null) {
            this.mLootGroups = new ArrayList<LootGroup>();
        }
    }

    public List<LootGroup> getLootTable() {
        this.Init();
        return this.mLootGroups;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    public static class LootGroup {
        @XmlAttribute(name="GroupMetaID")
        protected int mGroupID;
        @XmlAttribute(name="GroupName")
        protected String mGroupName;
        @XmlAttribute(name="Rarity")
        protected int mRarity;
        @XmlAttribute(name="MinItems")
        protected int mMinItems;
        @XmlAttribute(name="MaxItems")
        protected int mMaxItems;
        @XmlAttribute(name="CombineTrashGroup")
        protected boolean mCombineWithTrash;
        @XmlTransient
        private int mMaxWeight = -1;
        @XmlAttribute(name="LootbagIcon")
        private String mGroupIconResource;
        @XmlElement(name="Loot")
        private List<Drop> mDrops;

        public int getMinItems() {
            return this.mMinItems;
        }

        public int getMaxItems() {
            return this.mMaxItems;
        }

        public int getMaxWeight() {
            if (this.mMaxWeight == -1) {
                this.mMaxWeight = 0;
                for (Drop tDr : this.mDrops) {
                    this.mMaxWeight += tDr.mChance;
                }
            }
            return this.mMaxWeight;
        }

        public Optional<String> getGroupIconResource() {
            return Optional.ofNullable(this.mGroupIconResource);
        }

        public List<Drop> getDrops() {
            this.Init();
            return this.mDrops;
        }

        private void Init() {
            if (this.mDrops == null) {
                this.mDrops = new ArrayList<Drop>();
            }
        }

        public String getGroupName() {
            return this.mGroupName;
        }

        public int getGroupID() {
            return this.mGroupID;
        }

        public boolean getCombineWithTrash() {
            return this.mCombineWithTrash;
        }

        public EnumRarity getGroupRarity() {
            if (this.mRarity >= 0 && this.mRarity < EnumRarity.values().length) {
                return EnumRarity.values()[this.mRarity];
            }
            return EnumRarity.common;
        }

        public ItemStack createLootBagItemStack() {
            return new ItemStack(LootGroupsHandler.getLootBagItem(), 1, this.getGroupID());
        }

        public void shuffleLoot() {
            for (int i = 0; i < EnhancedLootBags.Rnd.nextInt(10); ++i) {
                Collections.shuffle(this.mDrops);
            }
        }

        public void updateMaxWeight() {
            this.mMaxWeight = -1;
            this.getMaxWeight();
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType
        public static class Drop {
            @XmlAttribute(name="Identifier")
            protected String mDropID;
            @XmlAttribute(name="ItemName")
            protected String mItemName;
            @XmlAttribute(name="Amount")
            protected int mAmount;
            @XmlAttribute(name="NBTTag")
            protected String mTag;
            @XmlAttribute(name="Chance")
            protected int mChance;
            @XmlAttribute(name="ItemGroup")
            protected String mItemGroup;
            @XmlAttribute(name="LimitedDropCount")
            protected int mLimitedDropCount;
            @XmlAttribute(name="RandomAmount")
            protected boolean mIsRandomAmount;

            public String getIdentifier() {
                return this.mDropID;
            }

            public String getItemDropGroup() {
                return this.mItemGroup == null ? "" : this.mItemGroup;
            }

            public String getItemName() {
                return this.mItemName;
            }

            @Nullable
            public ItemStack getItemStack() {
                return this.getItemStack(this.getAmount());
            }

            @Nullable
            public ItemStack getItemStack(int amount) {
                ItemDescriptor itemDesc = ItemDescriptor.fromString((String)this.getItemName(), (boolean)true);
                if (itemDesc == null) {
                    return null;
                }
                return itemDesc.getItemStackwNBT(amount, this.getNBTTag());
            }

            public int getAmount() {
                return this.mAmount;
            }

            public int getChance() {
                return this.mChance;
            }

            public int getLimitedDropCount() {
                return this.mLimitedDropCount;
            }

            public boolean getIsRandomAmount() {
                return this.mIsRandomAmount;
            }

            public String getNBTTag() {
                return this.mTag;
            }
        }
    }
}

