/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.command;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandSpaceStationChangeOwner
extends CommandBase {
    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " <dim#> <player>";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "ssnewowner";
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        String oldOwner = null;
        int stationID = -1;
        EntityPlayerMP playerAdmin = PlayerUtil.getPlayerBaseServerFromPlayerUsername(icommandsender.func_70005_c_(), true);
        if (astring.length <= 1) {
            throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssinvite.wrongUsage", this.func_71518_a(icommandsender)), new Object[0]);
        }
        String newOwner = astring[1];
        try {
            stationID = Integer.parseInt(astring[0]);
        }
        catch (Exception var6) {
            throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrongUsage", this.func_71518_a(icommandsender)), new Object[0]);
        }
        if (stationID < 2) {
            throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrongUsage", this.func_71518_a(icommandsender)), new Object[0]);
        }
        try {
            GCPlayerStats stats;
            SpaceStationWorldData stationData = SpaceStationWorldData.getMPSpaceStationData(null, stationID, null);
            if (stationData == null) {
                throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrongUsage", this.func_71518_a(icommandsender)), new Object[0]);
            }
            oldOwner = stationData.getOwner();
            stationData.getAllowedPlayers().remove(oldOwner);
            if (("Station: " + oldOwner).equals(stationData.getSpaceStationName())) {
                stationData.setSpaceStationName("Station: " + newOwner);
            }
            stationData.getAllowedPlayers().add(newOwner);
            stationData.setOwner(newOwner);
            EntityPlayerMP oldPlayer = PlayerUtil.getPlayerBaseServerFromPlayerUsername(oldOwner, true);
            EntityPlayerMP newPlayer = PlayerUtil.getPlayerBaseServerFromPlayerUsername(newOwner, true);
            if (oldPlayer != null) {
                stats = GCPlayerStats.get(oldPlayer);
                SpaceStationWorldData.updateSSOwnership(oldPlayer, oldOwner, stats, stationID, stationData);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{WorldUtil.spaceStationDataToString(stats.spaceStationDimensionData)}), oldPlayer);
            }
            if (newPlayer != null) {
                stats = GCPlayerStats.get(newPlayer);
                SpaceStationWorldData.updateSSOwnership(newPlayer, newOwner.replace(".", ""), stats, stationID, stationData);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{WorldUtil.spaceStationDataToString(stats.spaceStationDimensionData)}), newPlayer);
            }
        }
        catch (Exception var6) {
            throw new CommandException(var6.getMessage(), new Object[0]);
        }
        if (playerAdmin != null) {
            playerAdmin.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translateWithFormat("gui.spacestation.changesuccess", oldOwner, newOwner)));
        } else {
            System.out.println(GCCoreUtil.translateWithFormat("gui.spacestation.changesuccess", oldOwner, newOwner));
        }
    }

    protected String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

