/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemAdvChainsaw
extends ItemTool
implements IElectricItem {
    private int maxCharge;
    private int tier;
    private float effPower;
    private int energyPerOperation;
    private int transferLimit;
    public Set mineableBlocks = new HashSet();
    public int soundTicker;
    public int field_77865_bY;

    protected ItemAdvChainsaw(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.maxCharge = 45000;
        this.transferLimit = 500;
        this.tier = 2;
        this.field_77864_a = this.effPower = 30.0f;
        this.energyPerOperation = 100;
        this.field_77865_bY = 1;
        this.func_77637_a(GraviSuite.ic2Tab);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150344_f);
        this.mineableBlocks.add(Blocks.field_150342_X);
        this.mineableBlocks.add(Blocks.field_150376_bx);
        this.mineableBlocks.add(Blocks.field_150486_ae);
        this.mineableBlocks.add(Blocks.field_150362_t);
        this.mineableBlocks.add(Blocks.field_150321_G);
        this.mineableBlocks.add(Blocks.field_150325_L);
        this.mineableBlocks.add(Blocks.field_150423_aK);
        this.mineableBlocks.add(Blocks.field_150440_ba);
        this.mineableBlocks.add(Blocks.field_150434_aF);
        this.mineableBlocks.add(Blocks.field_150433_aE);
        ItemStack tmpItem = IC2Items.getItem((String)"rubberLeaves");
        if (tmpItem != null) {
            this.mineableBlocks.add(tmpItem);
        }
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(block, stack) || Items.field_151056_x.func_150893_a(stack, block) > 1.0f || Items.field_151048_u.canHarvestBlock(block, stack) || Items.field_151048_u.func_150893_a(stack, block) > 1.0f || this.mineableBlocks.contains(block);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass.equals("axe")) {
            return this.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, (double)this.energyPerOperation)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe");
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, attacker)) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 13.0f);
        } else {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (GraviSuite.isSimulating()) {
            IShearable target;
            Entity entity = event.target;
            EntityPlayer player = event.entityPlayer;
            ItemStack itemstack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
            if (itemstack != null && itemstack.func_77973_b() == this && entity instanceof IShearable && ItemAdvChainsaw.readToolMode(itemstack) == 0 && ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, (EntityLivingBase)player) && (target = (IShearable)entity).isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack stack = (ItemStack)drops.get(i);
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(field_77697_d.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                }
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (!GraviSuite.isSimulating()) {
            return false;
        }
        if (ItemAdvChainsaw.readToolMode(itemstack) != 0) {
            return false;
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, x, y, z) && ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, (EntityLivingBase)player)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = (ItemStack)drops.get(i);
                float f = 0.7f;
                double d = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedChainsaw");
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block block, int xPos, int yPos, int zPos, EntityLivingBase par7EntityLiving) {
        if ((double)block.func_149712_f(par2World, xPos, yPos, zPos) != 0.0) {
            if (par7EntityLiving != null) {
                ElectricItem.manager.use(par1ItemStack, (double)this.energyPerOperation, par7EntityLiving);
            } else {
                ElectricItem.manager.discharge(par1ItemStack, (double)this.energyPerOperation, this.tier, true, false, false);
            }
        }
        return true;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            Integer toolMode = ItemAdvChainsaw.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.advChainsaw.shear") + " " + Helpers.formatMessage("message.text.on"));
            }
            if (toolMode == 1) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.advChainsaw.shear") + " " + Helpers.formatMessage("message.text.off"));
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemAdvChainsaw.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GREEN + Helpers.formatMessage("message.advChainsaw.shear") + " " + Helpers.formatMessage("message.text.on"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.RED + Helpers.formatMessage("message.advChainsaw.shear") + " " + Helpers.formatMessage("message.text.off"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

