/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.DamageTakenEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.entity.mob.util.MultiDamage;
import chylex.hee.entity.weather.EntityWeatherLightningBoltSafe;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class DragonAttackSummoning
extends DragonSpecialAttackBase {
    private final TObjectByteHashMap<UUID> lastStriked = new TObjectByteHashMap(6);
    private byte summonTimer;
    private byte summoned;
    private int totalTimer;
    private boolean ended;

    public DragonAttackSummoning(EntityBossDragon dragon, int attackId, int weight) {
        super(dragon, attackId, weight);
    }

    @Override
    public void init() {
        super.init();
        this.lastStriked.clear();
        this.summoned = 0;
        this.summonTimer = 0;
        this.totalTimer = 1200;
        this.ended = false;
        this.dragon.target = null;
    }

    @Override
    public void update() {
        super.update();
        List<EntityPlayer> viablePlayers = this.dragon.attacks.getViablePlayers();
        this.summonTimer = (byte)(this.summonTimer + 1);
        if (this.summonTimer > 35 - Math.min(viablePlayers.size() * 4 + (ModCommonProxy.opMobs ? 5 : 0), 20)) {
            this.summonTimer = 0;
            boolean didSummon = false;
            int aggro = 0;
            int total = 0;
            for (int amt = MathUtil.clamp(MathUtil.ceil((double)viablePlayers.size() * (0.2 + this.rand.nextDouble() * 0.25)), 1, viablePlayers.size()); amt > 0; --amt) {
                int a;
                EntityPlayer player = viablePlayers.remove(this.rand.nextInt(viablePlayers.size()));
                for (EntityMobAngryEnderman enderman : this.dragon.field_70170_p.func_72872_a(EntityMobAngryEnderman.class, player.field_70121_D.func_72314_b(14.0, 5.0, 14.0))) {
                    if (enderman.func_70777_m() == player) {
                        ++aggro;
                    }
                    ++total;
                }
                if (aggro >= this.getDifficulty() || total >= 6 + this.getDifficulty()) continue;
                boolean flying = true;
                BlockPosM tmpPos = BlockPosM.tmp((Entity)player);
                int testY = MathUtil.floor(player.field_70163_u) - 1;
                for (a = 0; a < 5; ++a) {
                    if (tmpPos.setY(testY - a).isAir(this.dragon.field_70170_p)) continue;
                    flying = false;
                    break;
                }
                if (flying) {
                    if (this.lastStriked.adjustOrPutValue((Object)player.getPersistentID(), (byte)-1, (byte)0) > 0) continue;
                    MultiDamage.from((EntityLivingBase)this.dragon).addMagic(2.0f).addUnscaled(11.0f).attack((Entity)player);
                    player.func_70015_d(5);
                    this.dragon.field_70170_p.func_72942_c((Entity)new EntityWeatherLightningBoltSafe(this.dragon.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v));
                    this.lastStriked.put((Object)player.getPersistentID(), (byte)(4 + this.rand.nextInt(3)));
                    continue;
                }
                for (a = 0; a < 3 + this.rand.nextInt(this.getDifficulty()); ++a) {
                    double x = player.field_70165_t + (this.rand.nextDouble() - 0.5) * 13.0;
                    double z = player.field_70161_v + (this.rand.nextDouble() - 0.5) * 13.0;
                    int y = 1 + DragonUtil.getTopBlockY(this.dragon.field_70170_p, Blocks.field_150377_bs, MathUtil.floor(x), MathUtil.floor(z), MathUtil.floor(player.field_70163_u + 8.0));
                    EntityMobAngryEnderman enderman = new EntityMobAngryEnderman(this.dragon.field_70170_p);
                    enderman.func_70107_b(x, y, z);
                    enderman.func_70784_b((Entity)player);
                    if ((this.getDifficulty() > 1 || ModCommonProxy.opMobs) && this.rand.nextInt(100) < 5 + this.getDifficulty() * 10 + (ModCommonProxy.opMobs ? 25 : 0)) {
                        enderman.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 2400, 0, true));
                    }
                    this.dragon.field_70170_p.func_72942_c((Entity)new EntityWeatherLightningBoltSafe(this.dragon.field_70170_p, x, y, z));
                    this.dragon.field_70170_p.func_72838_d((Entity)enderman);
                }
                didSummon = true;
            }
            if (didSummon && (this.summoned = (byte)(this.summoned + 1)) > 2 + this.getDifficulty() + (ModCommonProxy.opMobs ? 1 : 0)) {
                this.ended = true;
            }
        }
        if (--this.totalTimer < 0) {
            this.ended = true;
        }
        if (this.dragon.field_70173_aa % 10 == 0 && MathUtil.distance(this.dragon.field_70165_t, this.dragon.field_70161_v) > 100.0) {
            this.dragon.targetX = (this.rand.nextDouble() - 0.5) * 60.0;
            this.dragon.targetZ = (this.rand.nextDouble() - 0.5) * 60.0;
        }
    }

    @Override
    public boolean canStart() {
        return this.getDifficulty() > 0;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public int getNextAttackTimer() {
        return super.getNextAttackTimer() + 100;
    }

    @Override
    public float overrideMovementSpeed() {
        return 0.7f;
    }

    @Override
    public void onDamageTakenEvent(DamageTakenEvent event) {
        this.totalTimer -= 40;
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        event.newTarget = null;
    }
}

