/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.technical;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.technical.EntityTechnicalBase;
import chylex.hee.mechanics.curse.CurseEvents;
import chylex.hee.mechanics.curse.CurseType;
import chylex.hee.mechanics.curse.ICurseCaller;
import chylex.hee.system.util.MathUtil;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityTechnicalCurseEntity
extends EntityTechnicalBase
implements ICurseCaller {
    private CurseType curseType;
    private boolean eternal;
    private byte usesLeft;
    private UUID targetID;
    private EntityLivingBase target;
    private float targetWidth;
    private float targetHeight;

    public EntityTechnicalCurseEntity(World world) {
        super(world);
    }

    public EntityTechnicalCurseEntity(World world, EntityLivingBase target, CurseType type, boolean eternal) {
        super(world);
        this.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        this.curseType = type;
        this.eternal = eternal;
        this.usesLeft = (byte)(target instanceof EntityPlayer ? (eternal ? 2 : 1) * type.getUses(CurseType.EnumCurseUse.PLAYER, this.field_70146_Z) : (eternal ? -1 : type.getUses(CurseType.EnumCurseUse.ENTITY, this.field_70146_Z)));
        this.targetID = target.func_110124_au();
        this.target = target;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.curseType == null) {
                this.curseType = CurseType.getFromDamage(this.field_70180_af.func_75683_a(16) - 1);
                if (this.curseType != null) {
                    this.targetWidth = this.field_70180_af.func_111145_d(17);
                    this.targetHeight = this.field_70180_af.func_111145_d(18);
                }
            }
            if (this.curseType != null) {
                double dist = HardcoreEnderExpansion.proxy.getClientSidePlayer().func_70032_d((Entity)this);
                if (dist > 32.0) {
                    return;
                }
                if (this.field_70146_Z.nextInt(dist > 16.0 ? 3 : 2) == 0) {
                    HardcoreEnderExpansion.fx.curse(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.targetWidth * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.targetHeight, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.targetWidth * 1.5, this.curseType);
                }
            }
            return;
        }
        if (this.field_70173_aa == 1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(this.curseType.damage + 1)));
        }
        if (this.target != null) {
            if (MathUtil.floatEquals(this.targetWidth, 0.0f)) {
                this.targetWidth = this.target.field_70130_N;
                this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(this.targetWidth));
                this.targetHeight = this.target.field_70131_O;
                this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.targetHeight));
            }
            if (this.target.field_71093_bK != this.field_71093_bK) {
                this.func_70107_b(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
                this.func_71027_c(this.target.field_71093_bK);
                return;
            }
            if (this.target.field_70128_L) {
                this.func_70106_y();
            }
            this.func_70107_b(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
            if (this.curseType.handler.tickEntity(this.target, this) && this.usesLeft != -1 && ((this.usesLeft = (byte)(this.usesLeft - 1)) <= 0 || CurseEvents.hasAmulet(this.target) && (this.usesLeft = (byte)(this.usesLeft - 1)) <= 0)) {
                this.curseType.handler.end(this.target, this);
                this.func_70106_y();
            }
        } else if (this.field_70173_aa < 20) {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D)) {
                if (!entity.func_110124_au().equals(this.targetID) || !(entity instanceof EntityLivingBase)) continue;
                this.target = (EntityLivingBase)entity;
                break;
            }
        } else {
            this.func_70106_y();
        }
    }

    public boolean compareTarget(EntityLivingBase entity) {
        return entity == this.target;
    }

    @Override
    public void onPurify() {
        if (this.curseType != null && this.target != null) {
            this.curseType.handler.end(this.target, this);
        }
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("curse", this.curseType.damage);
        nbt.func_74757_a("eternal", this.eternal);
        nbt.func_74774_a("usesLeft", this.usesLeft);
        nbt.func_74772_a("targ1", this.targetID.getLeastSignificantBits());
        nbt.func_74772_a("targ2", this.targetID.getMostSignificantBits());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.curseType = CurseType.getFromDamage(nbt.func_74771_c("curse"));
        if (this.curseType == null) {
            this.func_70106_y();
        }
        this.eternal = nbt.func_74767_n("eternal");
        this.usesLeft = nbt.func_74771_c("usesLeft");
        this.targetID = new UUID(nbt.func_74763_f("targ2"), nbt.func_74763_f("targ1"));
    }
}

