/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.energy;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EnergyChunkData {
    public static final float minSignificantEnergy = 1.0E-4f;
    public static final float energyDrainUnit = 0.12f;
    private int x;
    private int z;
    private float energyLevel;
    private float maxEnergyLevel;
    private byte regenTimer;
    private byte releaseTimer;

    private EnergyChunkData() {
    }

    public EnergyChunkData(int x, int z, Random rand) {
        this.x = x;
        this.z = z;
        float dist = (float)MathUtil.distance(x, z);
        float lowerBound = 4.0f + 2.0f * (dist / 6000.0f);
        float upperBound = 10.0f + 6.0f * (dist / 6000.0f);
        this.maxEnergyLevel = lowerBound + rand.nextFloat() * (upperBound - lowerBound);
        this.energyLevel = this.maxEnergyLevel - this.maxEnergyLevel * rand.nextFloat() * rand.nextFloat();
    }

    public void onUpdate(World world, Random rand) {
        if ((this.regenTimer == 0 || (this.regenTimer = (byte)(this.regenTimer - 1)) == 0) && this.energyLevel < this.maxEnergyLevel) {
            float f;
            this.energyLevel = (float)((double)this.energyLevel + Math.min((double)0.025f, Math.sqrt(this.maxEnergyLevel) * (double)0.007f));
            if (f > this.maxEnergyLevel) {
                this.energyLevel = this.maxEnergyLevel;
            }
            this.regenTimer = (byte)(9 + rand.nextInt(12 + rand.nextInt(6)) + MathUtil.floor(16.0f * this.energyLevel / this.maxEnergyLevel + this.maxEnergyLevel * 0.2f));
        }
        if ((this.energyLevel > this.maxEnergyLevel || this.energyLevel > this.maxEnergyLevel * 0.8f && rand.nextInt(10) == 0) && (this.releaseTimer == 0 || (this.releaseTimer = (byte)(this.releaseTimer - 1)) == 0)) {
            float release = (0.2f + rand.nextFloat() * 0.5f) * this.maxEnergyLevel * 0.0625f;
            if (this.energyLevel < release) {
                release = this.energyLevel;
            }
            this.energyLevel -= release;
            this.releaseTimer = (byte)(4 + rand.nextInt(7));
            BlockPosM.tmp(this.x + rand.nextInt(16), 8 + rand.nextInt(116), this.z + rand.nextInt(16)).setBlock(world, BlockList.corrupted_energy_low, MathUtil.clamp(MathUtil.floor(1.0f + release * 12.0f), 2, 8));
        }
    }

    public void onAdjacentInteract(Random rand, EnergyChunkData data) {
        float amt;
        if (rand.nextInt(42) == 0 && data.energyLevel < this.energyLevel && data.energyLevel < data.maxEnergyLevel && Math.abs(data.energyLevel - this.energyLevel) > 0.4f + rand.nextFloat() * 2.5f && (amt = Math.min(this.energyLevel, Math.min(data.maxEnergyLevel - data.energyLevel, Math.max(0.01f, Math.min(0.2f, Math.abs(data.energyLevel - this.energyLevel) * 0.02f * (0.8f + rand.nextFloat() * 0.2f)))))) > 1.0E-4f) {
            this.energyLevel -= amt;
            data.energyLevel += amt;
        }
    }

    public float addEnergy(float amount) {
        if (this.energyLevel + amount <= this.maxEnergyLevel * 2.0f) {
            this.energyLevel += amount;
            return 0.0f;
        }
        this.energyLevel = this.maxEnergyLevel * 2.0f;
        return this.energyLevel - amount;
    }

    public boolean drainEnergyUnit() {
        if (this.energyLevel >= 0.12f) {
            this.drainEnergy(0.12f);
            return true;
        }
        return false;
    }

    public float drainEnergy(float amount) {
        if (this.energyLevel - amount >= 0.0f) {
            this.energyLevel -= amount;
            return 0.0f;
        }
        float diff = amount - this.energyLevel;
        this.energyLevel = 0.0f;
        return diff;
    }

    public float getEnergyLevel() {
        return this.energyLevel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnergyChunkData) {
            EnergyChunkData data = (EnergyChunkData)obj;
            return data.x == this.x && data.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return 1664525 * this.x + 1013904223 ^ 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("z", this.z);
        tag.func_74776_a("lvl", this.energyLevel);
        tag.func_74776_a("max", this.maxEnergyLevel);
        return tag;
    }

    public static EnergyChunkData readFromNBT(NBTTagCompound nbt) {
        EnergyChunkData data = new EnergyChunkData();
        data.x = nbt.func_74762_e("x");
        data.z = nbt.func_74762_e("z");
        data.energyLevel = nbt.func_74760_g("lvl");
        data.maxEnergyLevel = nbt.func_74760_g("max");
        if (MathUtil.floatEquals(data.maxEnergyLevel, 0.0f)) {
            data.maxEnergyLevel = 1.0E-4f;
        }
        return data;
    }
}

