/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.ingame;

import chylex.hee.block.BlockDragonEggCustom;
import chylex.hee.block.BlockObsidianEnd;
import chylex.hee.block.BlockRavagedBrick;
import chylex.hee.entity.item.EntityItemAltar;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.brewing.PotionTypes;
import chylex.hee.mechanics.enhancements.types.EnhancedBrewingStandEnhancements;
import chylex.hee.mechanics.enhancements.types.EssenceAltarEnhancements;
import chylex.hee.mechanics.essence.EssenceType;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAccumulationTable;
import chylex.hee.tileentity.TileEntityDecompositionTable;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import chylex.hee.tileentity.TileEntityEnhancedBrewingStand;
import chylex.hee.tileentity.TileEntityEssenceAltar;
import chylex.hee.tileentity.TileEntityExperienceTable;
import chylex.hee.tileentity.TileEntityExtractionTable;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

@SideOnly(value=Side.CLIENT)
public class BlockTests {
    private static final String testTrigger = "ingame/blocks";
    private World world;
    private EntityPlayer player;
    private BlockPosM pos;
    private ArrayListMultimap<String, BlockPosM> storedLocs = ArrayListMultimap.create();

    public void setup() {
        if (this.world != null) {
            return;
        }
        this.world = DimensionManager.getWorld((int)0);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.pos = new BlockPosM();
        this.storedLocs.clear();
    }

    @UnitTest(type=MethodType.PREPARATION, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void prepBlockChunk() {
        int a;
        int a2;
        this.setup();
        this.pos.x = 0;
        while (this.pos.x < 16) {
            this.pos.z = 0;
            while (this.pos.z < 16) {
                this.pos.y = 4;
                while (this.pos.y < 128) {
                    if (this.pos.getBlock((IBlockAccess)this.world) == BlockList.energy_cluster) {
                        ((TileEntityEnergyCluster)this.pos.getTileEntity((IBlockAccess)this.world)).shouldNotExplode = true;
                    }
                    this.pos.setAir(this.world);
                    ++this.pos.y;
                }
                ++this.pos.z;
            }
            ++this.pos.x;
        }
        for (List list : this.world.func_72964_e((int)0, (int)0).field_76645_j) {
            for (Entity e : list) {
                if (e instanceof EntityPlayer) continue;
                e.func_70106_y();
            }
        }
        this.setFloor(0, 0, 8, Blocks.field_150417_aV);
        this.setPos(0, 0);
        this.setMove(BlockList.obsidian_falling);
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.obsidian_stairs, a2);
        }
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.obsidian_stairs, 4 + a2);
        }
        for (a2 = 0; a2 < 7; ++a2) {
            this.setMove(BlockList.obsidian_special, a2);
        }
        for (a2 = 0; a2 < 7; ++a2) {
            this.setMove(BlockList.obsidian_special_glow, a2);
        }
        for (a2 = 0; a2 < 3; ++a2) {
            this.setMove(BlockList.end_terrain, a2);
        }
        for (a2 = 0; a2 < BlockRavagedBrick.metaAmount; ++a2) {
            this.setMove(BlockList.ravaged_brick, a2);
        }
        this.setMove(BlockList.ravaged_brick_smooth);
        this.setMove(BlockList.ravaged_brick_glow);
        this.setMove(BlockList.ravaged_brick_slab);
        this.setMove(BlockList.ravaged_brick_slab, 8);
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.ravaged_brick_stairs, a2);
        }
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.ravaged_brick_stairs, 4 + a2);
        }
        this.setMove(BlockList.ravaged_brick_fence);
        this.setMove(BlockList.cinder);
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.persegrit, a2);
        }
        this.setMove(BlockList.laboratory_obsidian);
        this.setMove(BlockList.laboratory_floor);
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.laboratory_stairs, a2);
        }
        for (a2 = 0; a2 < 4; ++a2) {
            this.setMove(BlockList.laboratory_stairs, 4 + a2);
        }
        this.setMove(BlockList.sphalerite, 0);
        this.setMove(BlockList.endium_block);
        this.setMove(BlockList.laboratory_glass);
        this.setFloor(0, 10, 10, Blocks.field_150377_bs);
        this.setPos(0, 10);
        for (a2 = 0; a2 < 8; ++a2) {
            this.storedLocs.put((Object)"FallingBlockTarget", (Object)this.pos.copy());
            this.setMove(Blocks.field_150478_aa);
            this.storedLocs.put((Object)"FallingBlockTarget", (Object)this.pos.copy());
            this.setMove((Block)Blocks.field_150333_U);
        }
        this.setPos(0, 10);
        this.pos.moveUp().moveUp();
        for (a2 = 0; a2 < 2; ++a2) {
            this.storedLocs.put((Object)"FallingBlockObsidian", (Object)this.pos.copy());
            this.setMove(BlockList.obsidian_falling);
        }
        for (a2 = 0; a2 < 2; ++a2) {
            this.storedLocs.put((Object)"FallingBlockDragonEgg", (Object)this.pos.copy());
            this.setMove(Blocks.field_150380_bt);
        }
        this.setFloor(0, 12, 15, Blocks.field_150377_bs);
        this.setPos(0, 12);
        for (a2 = 2; a2 < 14; ++a2) {
            this.setMove(BlockList.crossed_decoration, a2);
        }
        this.setMove(BlockList.enderman_head, 1);
        this.setMove(BlockList.death_flower_pot, 0);
        this.setMove(BlockList.death_flower, 0);
        this.setFloor(1, 0, 13, Blocks.field_150417_aV);
        this.setPos(1, 0);
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.end_powder_ore);
        }
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.endium_ore);
        }
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.stardust_ore);
        }
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.igneous_rock_ore);
        }
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.instability_orb_ore);
        }
        for (a2 = 0; a2 < 16; ++a2) {
            this.setMove(BlockList.sphalerite, 1);
        }
        this.setFloor(1, 15, 15, Blocks.field_150417_aV);
        this.setPos(1, 15);
        this.setMove(BlockList.transport_beacon);
        this.setMove(BlockList.void_chest);
        this.setFloor(2, 0, 6, Blocks.field_150377_bs);
        this.setPos(2, 0);
        for (int run = 0; run < 2; ++run) {
            BlockPosM origin = this.pos.copy().setX(run == 0 ? 3 : 12).setZ(3);
            this.pos.set(origin).setBlock(this.world, BlockList.essence_altar, EssenceType.DRAGON.id);
            this.storedLocs.put((Object)"DragonEssenceAltar", (Object)this.pos.copy());
            this.getTile(TileEntityEssenceAltar.class).loadFromDamage(EssenceType.DRAGON.id);
            this.getTile(TileEntityEssenceAltar.class).getEnhancements().add(EssenceAltarEnhancements.SPEED);
            if (run == 1) {
                this.getTile(TileEntityEssenceAltar.class).getEnhancements().add(EssenceAltarEnhancements.EFFICIENCY);
            }
            try {
                Field essenceLevel = TileEntityEssenceAltar.class.getDeclaredField("essenceLevel");
                essenceLevel.setAccessible(true);
                essenceLevel.set(this.pos.getTileEntity((IBlockAccess)this.world), 512);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.pos.set(origin).move(-3, 0, 0).setBlock(this.world, Blocks.field_150417_aV);
            this.spawnItem((double)this.pos.x + 0.5, (double)this.pos.y + 1.25, (double)this.pos.z + 0.5, new ItemStack(Items.field_151067_bt));
            this.pos.set(origin).move(0, 0, -3).setBlock(this.world, Blocks.field_150417_aV);
            this.spawnItem((double)this.pos.x + 0.5, (double)this.pos.y + 1.25, (double)this.pos.z + 0.5, new ItemStack(Items.field_151061_bv));
            this.pos.set(origin).move(3, 0, 0).setBlock(this.world, Blocks.field_150417_aV);
            this.spawnItem((double)this.pos.x + 0.5, (double)this.pos.y + 1.25, (double)this.pos.z + 0.5, new ItemStack(ItemList.ghost_amulet, 1, 0));
            this.pos.set(origin).move(0, 0, 3).setBlock(this.world, Blocks.field_150417_aV);
            this.spawnItem((double)this.pos.x + 0.5, (double)this.pos.y + 1.25, (double)this.pos.z + 0.5, new ItemStack(Items.field_151048_u, 1, 50));
            this.pos.set(origin).move(2, 0, 2).setBlock(this.world, Blocks.field_150417_aV);
            this.pos.set(origin).move(-2, 0, 2).setBlock(this.world, Blocks.field_150417_aV);
            this.pos.set(origin).move(2, 0, -2).setBlock(this.world, Blocks.field_150417_aV);
            this.pos.set(origin).move(-2, 0, -2).setBlock(this.world, Blocks.field_150417_aV);
        }
        this.setFloor(2, 9, 15, Blocks.field_150377_bs);
        this.setPos(2, 0);
        this.pos.setX(3).setZ(12).setBlock(this.world, BlockList.essence_altar, EssenceType.FIERY.id);
        this.getTile(TileEntityEssenceAltar.class).loadFromDamage(EssenceType.FIERY.id);
        this.setFloor(3, 0, 3, Blocks.field_150377_bs);
        this.setPos(3, 0);
        ArrayList<Object[]> potions = new ArrayList<Object[]>();
        potions.add(new Object[]{0, Items.field_151075_bm, 0});
        potions.add(new Object[]{16, Items.field_151102_aT, 0});
        potions.add(new Object[]{8194, new ItemStack(Items.field_151114_aO, 2), 7});
        potions.add(new Object[]{8194, new ItemStack(Items.field_151114_aO, 3), 13, true});
        potions.add(new Object[]{8194, new ItemStack(Items.field_151137_ax, 8), 25});
        potions.add(new Object[]{8194, Items.field_151016_H, 3});
        potions.add(new Object[]{16, ItemList.silverfish_blood, 8});
        potions.add(new Object[]{16, ItemList.instability_orb, 8});
        potions.add(new Object[]{16, ItemList.ectoplasm, 8});
        for (Object[] t : potions) {
            this.storedLocs.put((Object)"EnhancedBrewingStand", (Object)this.pos.copy());
            this.set(BlockList.enhanced_brewing_stand);
            this.getTile(TileEntityEnhancedBrewingStand.class).func_70299_a(1, new ItemStack((Item)Items.field_151068_bn, 1, ((Integer)t[0]).intValue()));
            this.getTile(TileEntityEnhancedBrewingStand.class).func_70299_a(3, t[1] instanceof Item ? new ItemStack((Item)t[1]) : (ItemStack)t[1]);
            if ((Integer)t[2] != 0) {
                this.getTile(TileEntityEnhancedBrewingStand.class).func_70299_a(4, new ItemStack(ItemList.end_powder, ((Integer)t[2]).intValue()));
            }
            if (t.length > 3) {
                this.getTile(TileEntityEnhancedBrewingStand.class).getEnhancements().add(EnhancedBrewingStandEnhancements.TIER);
            }
            this.move();
        }
        this.setFloor(3, 5, 15, Blocks.field_150417_aV);
        this.setPos(3, 5);
        for (int a3 = -1; a3 <= 1; ++a3) {
            for (int b = -1; b <= 1; ++b) {
                this.pos.setX(5 + a3).setZ(10 + b).setBlock(this.world, BlockList.energy_cluster);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("status", (byte)0);
                tag.func_74776_a("lvl", 10.0f);
                tag.func_74776_a("max", 10.0f);
                this.getTile(TileEntityEnergyCluster.class).func_145845_h();
                this.getTile(TileEntityEnergyCluster.class).data.readFromNBT(tag);
            }
        }
        int y = this.pos.y;
        ItemStack[] decompositionTable = new ItemStack[]{new ItemStack((Item)Items.field_151163_ad), new ItemStack((Item)Items.field_151163_ad, 1, 528), new ItemStack(Blocks.field_150344_f, 4), new ItemStack(ItemList.energy_wand), new ItemStack(BlockList.void_chest), new ItemStack((Block)Blocks.field_150461_bJ), new ItemStack(Blocks.field_150357_h)};
        for (int a4 = -3; a4 <= 3; ++a4) {
            this.pos.setX(0).setY(y).setZ(10 + a4).setBlock(this.world, (Block)(a4 % 2 == 0 ? Blocks.field_150486_ae : Blocks.field_150447_bR));
            this.pos.moveUp().setBlock(this.world, (Block)Blocks.field_150438_bZ);
            this.pos.moveUp().setBlock(this.world, BlockList.decomposition_table);
            this.getTile(TileEntityDecompositionTable.class).func_70299_a(0, decompositionTable[a4 + 3]);
            this.getTile(TileEntityDecompositionTable.class).func_70299_a(1, new ItemStack(ItemList.stardust, 64));
            this.storedLocs.put((Object)"DecompositionTable", (Object)this.pos.copy());
        }
        ItemStack[] experienceTable = new ItemStack[]{new ItemStack(Blocks.field_150482_ag), new ItemStack(Blocks.field_150340_R, 3), new ItemStack(Items.field_151137_ax, 64), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(ItemList.endium_ingot, 17)};
        for (int a5 = -2; a5 <= 2; ++a5) {
            this.pos.setX(10).setY(y).setZ(10 + a5).setBlock(this.world, (Block)(a5 % 2 == 0 ? Blocks.field_150486_ae : Blocks.field_150447_bR));
            this.pos.moveUp().setBlock(this.world, (Block)Blocks.field_150438_bZ);
            this.pos.moveUp().setBlock(this.world, BlockList.experience_table);
            this.getTile(TileEntityExperienceTable.class).func_70299_a(0, experienceTable[a5 + 2]);
            this.getTile(TileEntityExperienceTable.class).func_70299_a(1, new ItemStack(ItemList.stardust, 64));
            this.storedLocs.put((Object)"ExperienceTable", (Object)this.pos.copy());
        }
        ItemStack[] accumulationTable = new ItemStack[]{new ItemStack(ItemList.temple_caller), new ItemStack(ItemList.spatial_dash_gem, 1, ItemList.spatial_dash_gem.func_77612_l() - 1), new ItemStack(ItemList.transference_gem, 1, ItemList.transference_gem.func_77612_l() - 1)};
        for (int a6 = -1; a6 <= 1; ++a6) {
            this.pos.setX(5 + a6).setY(y).setZ(5).setBlock(this.world, BlockList.accumulation_table);
            this.getTile(TileEntityAccumulationTable.class).func_70299_a(0, accumulationTable[a6 + 1]);
            this.storedLocs.put((Object)"AccumulationTable", (Object)this.pos.copy());
        }
        ItemStack[][] extractionTable = new ItemStack[][]{{new ItemStack(Blocks.field_150377_bs, 4), new ItemStack(BlockList.end_terrain, 2, 0), new ItemStack(BlockList.end_terrain, 2, 1), new ItemStack(BlockList.end_terrain, 2, 2)}, {new ItemStack(ItemList.energy_wand), new ItemStack(ItemList.energy_wand), new ItemStack(ItemList.energy_wand)}, {new ItemStack(BlockList.endium_block, 64)}};
        for (a = -1; a <= 1; ++a) {
            this.pos.setX(5 + a).setY(y).setZ(15).setBlock(this.world, BlockList.extraction_table);
            this.getTile(TileEntityExtractionTable.class).func_70299_a(1, new ItemStack(ItemList.stardust, 64));
            this.getTile(TileEntityExtractionTable.class).func_70299_a(2, new ItemStack(ItemList.instability_orb, 16));
            this.storedLocs.put((Object)"ExtractionTable", (Object)this.pos.copy());
            this.pos.moveUp().setBlock(this.world, (Block)Blocks.field_150438_bZ);
            for (int item = 0; item < extractionTable[a + 1].length; ++item) {
                this.getTile(TileEntityHopper.class).func_70299_a(item, extractionTable[a + 1][item]);
            }
        }
        for (a = 0; a < 2400; ++a) {
            this.world.func_72912_H().func_82572_b(this.world.func_72912_H().func_82573_f() + 1L);
            this.world.func_72955_a(false);
            this.world.func_72939_s();
        }
        if (MathUtil.distance(this.player.field_70165_t, this.player.field_70161_v) > 64.0) {
            this.player.func_70634_a(-1.0, (double)this.world.func_72825_h(-1, -1), -1.0);
        }
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testFallingBlocks() {
        Assert.equal(this.storedLocs.get((Object)"FallingBlockObsidian").size(), 2, "Unexpected amount of stored locs, expected $2, got $1.");
        for (BlockPosM testPos : this.storedLocs.get((Object)"FallingBlockObsidian")) {
            Assert.instanceOf(testPos.move(0, -2, 0).getBlock((IBlockAccess)this.world), BlockObsidianEnd.class, "Unexpected block class, expected $2, got $1.");
        }
        Assert.equal(this.storedLocs.get((Object)"FallingBlockDragonEgg").size(), 2, "Unexpected amount of stored locs, expected $2, got $1.");
        for (BlockPosM testPos : this.storedLocs.get((Object)"FallingBlockDragonEgg")) {
            Assert.instanceOf(testPos.move(0, -2, 0).getBlock((IBlockAccess)this.world), BlockDragonEggCustom.class, "Unexpected block class, expected $2, got $1.");
        }
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testDragonEssence() {
        int essence1 = -1;
        int essence2 = -1;
        Assert.equal(this.storedLocs.get((Object)"DragonEssenceAltar").size(), 2, "Unexpected amount of stored locs, expected $2, got $1.");
        for (BlockPosM testPos : this.storedLocs.get((Object)"DragonEssenceAltar")) {
            this.pos.set(testPos);
            if (essence1 == -1) {
                essence1 = this.getTile(TileEntityEssenceAltar.class).getEssenceLevel();
            } else {
                essence2 = this.getTile(TileEntityEssenceAltar.class).getEssenceLevel();
            }
            this.pos.set(testPos).move(-3, 1, 0);
            Assert.equal(this.getEntities(EntityItemAltar.class).get(0).func_92059_d().func_77973_b(), ItemList.enhanced_brewing_stand, "Unexpected altar item, expected $2, got $1.");
            this.pos.set(testPos).move(0, 1, -3);
            Assert.equal(this.getEntities(EntityItemAltar.class).get(0).func_92059_d().func_77973_b(), ItemList.temple_caller, "Unexpected altar item, expected $2, got $1.");
            this.pos.set(testPos).move(3, 1, 0);
            Assert.equal(this.getEntities(EntityItemAltar.class).get(0).func_92059_d().func_77960_j(), 1, "Unexpected altar item damage, expected $2, got $1.");
            this.pos.set(testPos).move(0, 1, 3);
            Assert.equal(this.getEntities(EntityItemAltar.class).get(0).func_92059_d().func_77960_j(), 0, "Unexpected altar item damage, expected $2, got $1.");
        }
        Assert.state(essence1 < essence2, "Unexpected Essence levels, expected " + essence1 + " to be lower than " + essence2 + ".");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testBrewing() {
        Object[][] data = new Object[][]{{0, new ItemStack((Item)Items.field_151068_bn, 1, 16)}, {0, new ItemStack((Item)Items.field_151068_bn, 1, 8194)}, {1, PotionTypes.setCustomPotionEffect(new ItemStack((Item)Items.field_151068_bn, 1, 8194), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 2))}, {1, PotionTypes.setCustomPotionEffect(new ItemStack((Item)Items.field_151068_bn, 1, 8194), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 3))}, {1, PotionTypes.setCustomPotionEffect(new ItemStack((Item)Items.field_151068_bn, 1, 8194), new PotionEffect(Potion.field_76424_c.field_76415_H, 14400, 0))}, {0, PotionTypes.setCustomPotionEffect(new ItemStack((Item)Items.field_151068_bn, 1, 24578), new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 0))}, {0, new ItemStack(ItemList.infestation_remedy)}, {0, new ItemStack(ItemList.potion_of_instability)}, {0, new ItemStack(ItemList.potion_of_purity)}};
        List stands = this.storedLocs.get((Object)"EnhancedBrewingStand");
        for (int a = 0; a < data.length; ++a) {
            this.pos.set((BlockPosM)stands.get(a));
            if ((Integer)data[a][0] == 0) {
                Assert.isNull(this.getTile(TileEntityEnhancedBrewingStand.class).func_70301_a(4), "Unexpected item, expected powder slot to be empty.");
            } else {
                Assert.equal(this.getTile(TileEntityEnhancedBrewingStand.class).func_70301_a((int)4).field_77994_a, data[a][0], "Unexpected powder amount, expected $2, got $1.");
            }
            Assert.equal(this.getTile(TileEntityEnhancedBrewingStand.class).func_70301_a(1), data[a][1], "Unexpected potion item, expected $2, got $1.");
        }
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testDecompositionTable() {
        int[] stardust = new int[]{59, 59, 63, 61, 57, 57, 64};
        final List decomposition = this.storedLocs.get((Object)"DecompositionTable");
        for (int a = 0; a < stardust.length; ++a) {
            this.pos.set((BlockPosM)decomposition.get(a));
            Assert.equal(this.getTile(TileEntityDecompositionTable.class).func_70301_a((int)1).field_77994_a, stardust[a], "Unexpected stardust amount, expected $2, got $1.");
        }
        Function<Integer, TileEntityChest> get = new Function<Integer, TileEntityChest>(){

            public TileEntityChest apply(Integer input) {
                return (TileEntityChest)BlockTests.this.pos.set((BlockPosM)decomposition.get(input)).move(0, -2, 0).getTileEntity((IBlockAccess)BlockTests.this.world);
            }
        };
        Assert.equal(((TileEntityChest)get.apply((Object)0)).func_70301_a(0).func_77973_b(), Items.field_151045_i, "Unexpected item, expected $2, got $1.");
        Assert.state(((TileEntityChest)get.apply((Object)Integer.valueOf((int)0))).func_70301_a((int)0).field_77994_a > 3, "Unexpected state, expected stack size to be greater than 4.");
        Assert.equal(((TileEntityChest)get.apply((Object)1)).func_70301_a(0).func_77973_b(), Items.field_151045_i, "Unexpected item, expected $2, got $1.");
        Assert.equal(((TileEntityChest)get.apply((Object)Integer.valueOf((int)1))).func_70301_a((int)0).field_77994_a, 1, "Unexpected stack size, expected $2, got $1.");
        Assert.equal(((TileEntityChest)get.apply((Object)2)).func_70301_a(0).func_77973_b(), Item.func_150898_a((Block)Blocks.field_150364_r), "Unexpected item, expected $2, got $1.");
        Assert.notNull(((TileEntityChest)get.apply((Object)3)).func_70301_a(0), "Unexpected item, expected it not to be null.");
        Assert.notNull(((TileEntityChest)get.apply((Object)4)).func_70301_a(0), "Unexpected item, expected it not to be null.");
        Assert.notNull(((TileEntityChest)get.apply((Object)5)).func_70301_a(0), "Unexpected item, expected it not to be null.");
        Assert.isNull(((TileEntityChest)get.apply((Object)6)).func_70301_a(0), "Unexpected item, expected it to be null.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testExperienceTable() {
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testAccumulationTable() {
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.INGAME, trigger="ingame/blocks")
    public void testExtractionTable() {
    }

    private void setFloor(int floor, int startRow, int endRow, Block block) {
        this.pos.set(0, 9 + 6 * floor, startRow);
        for (int a = 0; a < (1 + endRow - startRow) * 16; ++a) {
            this.setMove(block);
        }
    }

    private void setPos(int floor, int z) {
        this.pos.set(0, 10 + 6 * floor, z);
    }

    private void setMove(Block block) {
        this.pos.setBlock(this.world, block);
        this.move();
    }

    private void setMove(Block block, int meta) {
        this.pos.setBlock(this.world, block, meta);
        this.move();
    }

    private void set(Block block) {
        this.pos.setBlock(this.world, block);
    }

    private void set(Block block, int meta) {
        this.pos.setBlock(this.world, block, meta);
    }

    private void move() {
        this.pos.move(1, 0, 0);
        if (this.pos.x >= 16) {
            this.pos.setX(0).move(0, 0, 1);
        }
    }

    private <T> T getTile(Class<T> cls) {
        return (T)this.pos.getTileEntity((IBlockAccess)this.world);
    }

    private <T extends Entity> List<T> getEntities(Class<T> cls) {
        return this.world.func_72872_a(cls, AxisAlignedBB.func_72330_a((double)this.pos.x, (double)this.pos.y, (double)this.pos.z, (double)(this.pos.x + 1), (double)(this.pos.y + 1), (double)(this.pos.z + 1)));
    }

    private void spawnItem(double x, double y, double z, ItemStack is) {
        EntityItem item = new EntityItem(this.world, x, y, z, is);
        item.field_70179_y = 0.0;
        item.field_70181_x = 0.0;
        item.field_70159_w = 0.0;
        item.field_145804_b = 10;
        this.world.func_72838_d((Entity)item);
    }

    private void runEntity(Entity entity, int ticks) {
        Assert.notNull(entity, "Unexpected argument, entity is null.");
        for (int a = 0; a < ticks; ++a) {
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70136_U = entity.field_70161_v;
            entity.field_70126_B = entity.field_70177_z;
            entity.field_70127_C = entity.field_70125_A;
            ++entity.field_70173_aa;
            entity.func_70071_h_();
            if (!entity.field_70128_L) continue;
            return;
        }
    }

    private void runTile(TileEntity tile, int ticks) {
        Assert.notNull(tile, "Unexpected argument, tile entity is null.");
        for (int a = 0; a < ticks; ++a) {
            tile.func_145845_h();
        }
    }
}

