/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.block.BlockEnergyCluster;
import chylex.hee.mechanics.energy.EnergyClusterData;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C10ParticleEnergyTransfer;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.ColorUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractEnergyInventory;
import chylex.hee.tileentity.TileEntityAbstractSynchronized;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityEnergyCluster
extends TileEntityAbstractSynchronized {
    public final EnergyClusterData data;
    public boolean shouldNotExplode = false;
    private boolean shouldBeDestroyedSilently = false;
    private byte[] colRgb;
    private BlockPosM cachedCoords = new BlockPosM(0, -1, 0);

    public TileEntityEnergyCluster() {
        this.data = new EnergyClusterData();
    }

    public TileEntityEnergyCluster(World world) {
        this();
        float[] rgb = ColorUtil.hsvToRgb(world.field_73012_v.nextFloat(), 0.5f, 0.65f);
        this.colRgb = new byte[]{(byte)(Math.floor(rgb[0] * 255.0f) - 128.0), (byte)(Math.floor(rgb[1] * 255.0f) - 128.0), (byte)(Math.floor(rgb[2] * 255.0f) - 128.0)};
    }

    public void func_145845_h() {
        if (this.shouldBeDestroyedSilently) {
            this.shouldNotExplode = true;
            BlockPosM.tmp(this.field_145851_c, this.field_145848_d, this.field_145849_e).setAir(this.field_145850_b);
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.cachedCoords.y == -1) {
                this.data.generate(this.field_145850_b, this.field_145851_c, this.field_145849_e);
                this.cachedCoords = new BlockPosM(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.synchronize();
            } else if (this.cachedCoords.x != this.field_145851_c || this.cachedCoords.y != this.field_145848_d || this.cachedCoords.z != this.field_145849_e) {
                BlockEnergyCluster.destroyCluster(this);
                return;
            }
            this.data.update(this);
        } else if (this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            HardcoreEnderExpansion.fx.energyCluster(this);
        }
        this.shouldNotExplode = false;
    }

    public float addEnergy(float amount, TileEntityAbstractEnergyInventory tile) {
        float left;
        if (this.data.getEnergyLevel() < this.data.getMaxEnergyLevel()) {
            PacketPipeline.sendToAllAround(this, 64.0, (AbstractPacket)new C10ParticleEnergyTransfer(tile, this));
        }
        if (!MathUtil.floatEquals(left = this.data.addEnergy(amount), amount)) {
            this.synchronize();
        }
        return left;
    }

    public float drainEnergy(float amount, TileEntityAbstractEnergyInventory tile) {
        float left;
        if (this.data.getEnergyLevel() >= 1.0E-4f) {
            PacketPipeline.sendToAllAround(this, 64.0, (AbstractPacket)new C10ParticleEnergyTransfer(tile, this));
        }
        if (!MathUtil.floatEquals(left = this.data.drainEnergy(amount), amount)) {
            this.synchronize();
        }
        return left;
    }

    public float getColor(int index) {
        return ((float)this.colRgb[index] + 128.0f) / 255.0f;
    }

    public byte getColorRaw(int index) {
        return this.colRgb[index];
    }

    @Override
    public NBTTagCompound writeTileToNBT(NBTTagCompound nbt) {
        nbt.func_74773_a("col", this.colRgb);
        nbt.func_74772_a("loc", this.cachedCoords.toLong());
        this.data.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void readTileFromNBT(NBTTagCompound nbt) {
        this.colRgb = nbt.func_74770_j("col");
        this.cachedCoords = BlockPosM.fromNBT(nbt, "loc");
        this.data.readFromNBT(nbt);
        if (this.colRgb.length == 0) {
            this.shouldBeDestroyedSilently = true;
        }
    }
}

