/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.generators;

import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.Random;
import net.minecraft.util.Vec3;

public class BlobGeneratorChain
extends BlobGenerator {
    private IRandomAmount amountGen = IRandomAmount.exact;
    private byte minAmount;
    private byte maxAmount;
    private double minRad;
    private double maxRad;
    private double minChainDistMp;
    private double maxChainDistMp;
    private boolean unifiedSize;

    public BlobGeneratorChain(int weight) {
        super(weight);
    }

    public BlobGeneratorChain amount(IRandomAmount amountGen, int minAmount, int maxAmount) {
        this.amountGen = amountGen;
        this.minAmount = (byte)minAmount;
        this.maxAmount = (byte)maxAmount;
        return this;
    }

    public BlobGeneratorChain rad(double minRad, double maxRad) {
        this.minRad = minRad;
        this.maxRad = maxRad;
        return this;
    }

    public BlobGeneratorChain distMp(double minChainDistMp, double maxChainDistMp) {
        this.minChainDistMp = minChainDistMp;
        this.maxChainDistMp = maxChainDistMp;
        return this;
    }

    public BlobGeneratorChain unifySize() {
        this.unifiedSize = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        double prevRad = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int amount = this.amountGen.generate(rand, this.minAmount, this.maxAmount);
        for (int a = 0; a < amount; ++a) {
            double rad = this.unifiedSize && a > 0 ? prevRad : this.minRad + rand.nextDouble() * (this.maxRad - this.minRad);
            Vec3 vec = a == 0 ? Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0) : DragonUtil.getRandomVector(rand);
            double dist = a == 0 ? 0.0 : prevRad * (this.minChainDistMp + rand.nextDouble() * (this.maxChainDistMp - this.minChainDistMp));
            BlobGeneratorChain.genBlob(gen, x += vec.field_72450_a * dist, y += vec.field_72448_b * dist, z += vec.field_72449_c * dist, rad);
            prevRad = rad;
        }
    }
}

