/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.harvestlevels;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import iguanaman.iguanatweakstconstruct.harvestlevels.HarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.harvestlevels.TinkerMaterialTweaks;
import iguanaman.iguanatweakstconstruct.harvestlevels.VanillaToolTipHandler;
import iguanaman.iguanatweakstconstruct.harvestlevels.modifiers.ModBonusMiningLevel;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.Map;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;

@Pulse(id="HarvestLevelTweaks", description="Modify tool and item mining levels to create a tiered-ish progression")
public class IguanaHarvestLevelTweaks {
    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        TinkerMaterialTweaks.modifyToolMaterials();
        HarvestLevelTweaks.modifyHarvestLevels();
        MinecraftForge.EVENT_BUS.register((Object)new VanillaToolTipHandler());
        if (Config.changeDiamondModifier) {
            this.changeDurabilityModifiers();
        }
        if (TConstruct.pulsar.isPulseLoaded("Tinkers' World")) {
            this.adaptChestLoot();
        }
    }

    private void adaptChestLoot() {
        for (Map.Entry mat : TConstructRegistry.toolMaterials.entrySet()) {
            if (((ToolMaterial)mat.getValue()).harvestLevel() <= HarvestLevels._1_flint) continue;
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.pickaxeHead, 1, ((Integer)mat.getKey()).intValue()));
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.hammerHead, 1, ((Integer)mat.getKey()).intValue()));
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.shovelHead, 1, ((Integer)mat.getKey()).intValue()));
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.excavatorHead, 1, ((Integer)mat.getKey()).intValue()));
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.hatchetHead, 1, ((Integer)mat.getKey()).intValue()));
            TinkerWorld.tinkerHouseChest.removeItem(new ItemStack(TinkerTools.broadAxeHead, 1, ((Integer)mat.getKey()).intValue()));
        }
    }

    private void changeDurabilityModifiers() {
        PHConstruct.miningLevelIncrease = false;
        Log.debug("Adding Diamond/Emerald Modifiers for Mining Levels");
        ModifyBuilder.registerModifier((ItemModifier)new ModBonusMiningLevel(new ItemStack[]{new ItemStack(Items.field_151045_i)}, "Diamond"));
        ModifyBuilder.registerModifier((ItemModifier)new ModBonusMiningLevel(new ItemStack[]{new ItemStack(Items.field_151166_bC)}, "Emerald"));
    }
}

