/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.AutoValue_RecipeHandler_Lens;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.AutoValue_RecipeHandler_Recipe;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.LensColour;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.OreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechRecipeUtil;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;

class RecipeHandler {
    static final String LENS_COLOUR_ORE_NAME_PREFIX = "craftingLens";
    private final SortedSetMultimap<Lens, Recipe> lensRecipes = MultimapBuilder.treeKeys().treeSetValues().build();
    private final SortedSetMultimap<LensColour, Lens> lensColours = MultimapBuilder.enumKeys(LensColour.class).treeSetValues().build();
    private final SortedSetMultimap<LensColour, Recipe> colourRecipes = MultimapBuilder.enumKeys(LensColour.class).treeSetValues().build();

    RecipeHandler() {
    }

    void initialize() {
        RecipeMaps.laserEngraverRecipes.getAllRecipes().forEach(this::handleRecipe);
        for (LensColour colour : this.lensColours.keySet()) {
            SortedSet currentRecipes = null;
            for (Lens lens : this.lensColours.get((Object)colour)) {
                SortedSet currentLensRecipes = this.lensRecipes.get((Object)lens);
                if (currentRecipes == null) {
                    currentRecipes = currentLensRecipes;
                }
                currentRecipes = Sets.intersection((Set)currentRecipes, (Set)currentLensRecipes);
            }
            if (currentRecipes == null) continue;
            this.colourRecipes.putAll((Object)colour, currentRecipes);
        }
    }

    void handleRecipe(GTRecipe recipe) {
        ItemComponent input;
        ItemComponent lensItemComponent;
        List inputs = GregTechRecipeUtil.buildComponentsFromItemInputs(recipe).stream().map(DisplayComponent::component).map(ItemComponent.class::cast).collect(Collectors.toList());
        List<DisplayComponent> outputs = GregTechRecipeUtil.buildComponentsFromItemOutputs(recipe);
        if (inputs.size() != 2 || outputs.size() != 1) {
            Logger.GREGTECH_5_LENSES.warn("Found a malformed recipe: [{}] [{}]", new Object[]{inputs, outputs});
            return;
        }
        if (RecipeHandler.isLens((Component)inputs.get(1))) {
            lensItemComponent = (ItemComponent)inputs.get(1);
            input = (ItemComponent)inputs.get(0);
        } else if (RecipeHandler.isLens((Component)inputs.get(0))) {
            lensItemComponent = (ItemComponent)inputs.get(0);
            input = (ItemComponent)inputs.get(1);
        } else {
            return;
        }
        DisplayComponent output = outputs.get(0);
        List lensColourOreNames = OreDictUtil.getOreNames(lensItemComponent).stream().filter(oreName -> oreName.startsWith(LENS_COLOUR_ORE_NAME_PREFIX)).collect(Collectors.toList());
        if (lensColourOreNames.size() > 1) {
            Logger.GREGTECH_5_LENSES.warn("Found a multi-coloured lens: [{}] [{}]", new Object[]{lensItemComponent, lensColourOreNames});
            return;
        }
        LensColour colour = lensColourOreNames.isEmpty() ? LensColour.UNIQUE : LensColour.get((String)Iterables.getOnlyElement(lensColourOreNames));
        Lens lens = Lens.create(colour, lensItemComponent);
        this.lensRecipes.put((Object)lens, (Object)Recipe.create(input, output));
        this.lensColours.put((Object)colour, (Object)lens);
    }

    ImmutableSet<Lens> allLenses() {
        return ImmutableSet.copyOf((Collection)this.lensRecipes.keySet());
    }

    ImmutableSortedSet<Recipe> recipes(Lens lens) {
        return ImmutableSortedSet.copyOf((Collection)this.lensRecipes.get((Object)lens));
    }

    ImmutableSortedSet<Lens> lenses(LensColour colour) {
        return ImmutableSortedSet.copyOf((Collection)this.lensColours.get((Object)colour));
    }

    boolean isColourRecipe(LensColour colour, Recipe recipe) {
        return this.colourRecipes.get((Object)colour).contains(recipe);
    }

    private static boolean isLens(Component component) {
        Optional<ItemData> itemDataOptional = GregTechOreDictUtil.getItemData(component);
        if (!itemDataOptional.isPresent()) {
            return false;
        }
        return itemDataOptional.get().mPrefix == OrePrefixes.lens;
    }

    @AutoValue
    static abstract class Recipe
    implements Comparable<Recipe> {
        private static final Comparator<Recipe> COMPARATOR = Comparator.comparing(Recipe::input);

        Recipe() {
        }

        static Recipe create(ItemComponent input, DisplayComponent output) {
            return new AutoValue_RecipeHandler_Recipe(input, output);
        }

        abstract ItemComponent input();

        abstract DisplayComponent output();

        @Override
        public int compareTo(Recipe other) {
            return COMPARATOR.compare(this, other);
        }
    }

    @AutoValue
    static abstract class Lens
    implements Comparable<Lens> {
        private static final Comparator<Lens> COMPARATOR = Comparator.comparing(Lens::colour).thenComparing(Lens::itemComponent);

        Lens() {
        }

        static Lens create(LensColour colour, ItemComponent itemComponent) {
            return new AutoValue_RecipeHandler_Lens(colour, itemComponent);
        }

        abstract LensColour colour();

        abstract ItemComponent itemComponent();

        @Override
        public int compareTo(Lens other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

