/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import codechicken.core.TaskProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncTaskProfiler
extends TaskProfiler {
    public ThreadLocal<TaskProfiler> threadedProfiler = ThreadLocal.withInitial(TaskProfiler::new);
    public Map<String, Long> times = new ConcurrentHashMap<String, Long>();

    public void start(String section) {
        if (section == null) {
            section = "<unnamed>";
        }
        this.threadedProfiler.get().start(section);
    }

    public void end() {
        TaskProfiler profiler = this.threadedProfiler.get();
        if (profiler != null) {
            profiler.end();
            if (profiler.times != null && !profiler.times.isEmpty()) {
                this.times.putAll(this.threadedProfiler.get().times);
            }
        }
    }

    public List<TaskProfiler.ProfilerResult> getResults() {
        ArrayList<TaskProfiler.ProfilerResult> results = new ArrayList<TaskProfiler.ProfilerResult>(this.times.size());
        long totalTime = this.times.values().stream().reduce(0L, Long::sum);
        for (Map.Entry<String, Long> e : this.times.entrySet()) {
            results.add(new TaskProfiler.ProfilerResult(e.getKey(), e.getValue().longValue(), totalTime));
        }
        return results;
    }

    public void clear() {
        if (this.threadedProfiler.get().currentSection != null) {
            this.threadedProfiler.get().end();
        }
        this.threadedProfiler.get().clear();
        this.times.clear();
    }

    public void clearCurrent() {
        if (this.threadedProfiler.get().currentSection != null) {
            this.threadedProfiler.get().end();
        }
        this.threadedProfiler.get().clear();
    }
}

