/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamSerializer;

public class GameProfileSerializer
implements IStreamSerializer<GameProfile> {
    public static final IStreamSerializer<GameProfile> INSTANCE = new GameProfileSerializer();

    @Override
    public void writeToStream(GameProfile o, DataOutput output) throws IOException {
        GameProfileSerializer.write(o, output);
    }

    @Override
    public GameProfile readFromStream(DataInput input) throws IOException {
        return GameProfileSerializer.read(input);
    }

    public static void write(GameProfile o, DataOutput output) throws IOException {
        UUID uuid = o.getId();
        output.writeUTF(uuid == null ? "" : uuid.toString());
        output.writeUTF(Strings.nullToEmpty((String)o.getName()));
        PropertyMap properties = o.getProperties();
        ByteUtils.writeVLI(output, properties.size());
        for (Property p : properties.values()) {
            output.writeUTF(p.getName());
            output.writeUTF(p.getValue());
            String signature = p.getSignature();
            if (signature != null) {
                output.writeBoolean(true);
                output.writeUTF(signature);
                continue;
            }
            output.writeBoolean(false);
        }
    }

    public static GameProfile read(DataInput input) throws IOException {
        String uuidStr = input.readUTF();
        UUID uuid = Strings.isNullOrEmpty((String)uuidStr) ? null : UUID.fromString(uuidStr);
        String name = input.readUTF();
        GameProfile result = new GameProfile(uuid, name);
        int propertyCount = ByteUtils.readVLI(input);
        PropertyMap properties = result.getProperties();
        for (int i = 0; i < propertyCount; ++i) {
            String key = input.readUTF();
            String value = input.readUTF();
            if (input.readBoolean()) {
                String signature = input.readUTF();
                properties.put((Object)key, (Object)new Property(key, value, signature));
                continue;
            }
            properties.put((Object)key, (Object)new Property(key, value));
        }
        return result;
    }
}

