/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.spdy;

import java.util.Set;
import mcp.mobius.shadow.io.nettyopis.buffer.ByteBuf;
import mcp.mobius.shadow.io.nettyopis.buffer.Unpooled;
import mcp.mobius.shadow.io.nettyopis.handler.codec.spdy.SpdyHeaderBlockEncoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.spdy.SpdyHeadersFrame;
import mcp.mobius.shadow.io.nettyopis.handler.codec.spdy.SpdyVersion;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version.getVersion();
    }

    private static void setLengthField(ByteBuf buffer, int writerIndex, int length) {
        buffer.setInt(writerIndex, length);
    }

    private static void writeLengthField(ByteBuf buffer, int length) {
        buffer.writeInt(length);
    }

    @Override
    public ByteBuf encode(SpdyHeadersFrame frame) throws Exception {
        Set<String> names = frame.headers().names();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf headerBlock = Unpooled.buffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, numHeaders);
        for (String name : names) {
            byte[] nameBytes = name.getBytes("UTF-8");
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, nameBytes.length);
            headerBlock.writeBytes(nameBytes);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, valueLength);
            for (String value : frame.headers().getAll(name)) {
                byte[] valueBytes = value.getBytes("UTF-8");
                if (valueBytes.length <= 0) continue;
                headerBlock.writeBytes(valueBytes);
                headerBlock.writeByte(0);
                valueLength += valueBytes.length + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            if (valueLength <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    @Override
    void end() {
    }
}

