/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.apache.commons.math3.optim.nonlinear.scalar;

import mcp.mobius.shadow.org.apache.commons.math3.analysis.MultivariateFunction;
import mcp.mobius.shadow.org.apache.commons.math3.exception.TooManyEvaluationsException;
import mcp.mobius.shadow.org.apache.commons.math3.optim.BaseMultivariateOptimizer;
import mcp.mobius.shadow.org.apache.commons.math3.optim.ConvergenceChecker;
import mcp.mobius.shadow.org.apache.commons.math3.optim.OptimizationData;
import mcp.mobius.shadow.org.apache.commons.math3.optim.PointValuePair;
import mcp.mobius.shadow.org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import mcp.mobius.shadow.org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultivariateOptimizer
extends BaseMultivariateOptimizer<PointValuePair> {
    private MultivariateFunction function;
    private GoalType goal;

    protected MultivariateOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        return (PointValuePair)super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof GoalType) {
                this.goal = (GoalType)data;
                continue;
            }
            if (!(data instanceof ObjectiveFunction)) continue;
            this.function = ((ObjectiveFunction)data).getObjectiveFunction();
        }
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    protected double computeObjectiveValue(double[] params) {
        super.incrementEvaluationCount();
        return this.function.value(params);
    }
}

