/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.gui.buttons.ButtonTextureSet;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.IOverlayMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLoaderItemBase
extends TileLoaderBase
implements IGuiReturnHandler,
ISidedInventory {
    protected static final int[] SLOTS = InvTools.buildSlotArray(0, 9);
    private final PhantomInventory invFilters = new PhantomInventory(9, this);
    private final MultiButtonController<EnumTransferMode> transferModeController = new MultiButtonController(EnumTransferMode.ALL.ordinal(), (IMultiButtonState[])EnumTransferMode.values());
    private final MultiButtonController<EnumRedstoneMode> redstoneModeController = new MultiButtonController(0, (IMultiButtonState[])this.getValidRedstoneModes());
    private final MultiButtonController<MatchNBTMode> matchNbtController = new MultiButtonController(0, (IMultiButtonState[])MatchNBTMode.values());
    private final MultiButtonController<MatchMetadataMode> matchMetadataController = new MultiButtonController(0, (IMultiButtonState[])MatchMetadataMode.values());
    protected boolean movedItemCart = false;

    public MultiButtonController<EnumTransferMode> getTransferModeController() {
        return this.transferModeController;
    }

    public EnumRedstoneMode[] getValidRedstoneModes() {
        return EnumRedstoneMode.values();
    }

    public MultiButtonController<EnumRedstoneMode> getRedstoneModeController() {
        return this.redstoneModeController;
    }

    public MultiButtonController<MatchNBTMode> getMatchNbtController() {
        return this.matchNbtController;
    }

    public MultiButtonController<MatchMetadataMode> getMatchMetadataController() {
        return this.matchMetadataController;
    }

    public final PhantomInventory getItemFilters() {
        return this.invFilters;
    }

    public abstract Slot getBufferSlot(int var1, int var2, int var3);

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    protected void setPowered(boolean p) {
        if (!this.isSendCartGateAction() && this.redstoneModeController.getButtonState() == EnumRedstoneMode.MANUAL) {
            super.setPowered(false);
            return;
        }
        super.setPowered(p);
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (this.isSendCartGateAction()) {
            return false;
        }
        if (!(cart instanceof IInventory)) {
            return false;
        }
        IInventory cartInv = (IInventory)cart;
        if (cartInv.func_70302_i_() <= 0) {
            return false;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        return minecartSlot1 == null && minecartSlot2 == null || CartUtils.doesCartMatchFilter(minecartSlot1, cart) || CartUtils.doesCartMatchFilter(minecartSlot2, cart);
    }

    @Override
    public boolean isProcessing() {
        return this.movedItemCart;
    }

    @Override
    public boolean isManualMode() {
        return this.redstoneModeController.getButtonState() == EnumRedstoneMode.MANUAL;
    }

    public final EnumTransferMode getMode() {
        return this.transferModeController.getButtonState();
    }

    public boolean isMatchByNBT() {
        return this.matchNbtController.getButtonState() == MatchNBTMode.MATCH_NBT;
    }

    public void setMatchByNBT(boolean matchByNBT) {
        this.matchNbtController.setCurrentState(matchByNBT ? MatchNBTMode.MATCH_NBT : MatchNBTMode.IGNORE_NBT);
    }

    public boolean isMatchByMetadata() {
        return this.matchMetadataController.getButtonState() == MatchMetadataMode.MATCH_METADATA;
    }

    public void setMatchByMetadata(boolean matchByMetadata) {
        this.matchMetadataController.setCurrentState(matchByMetadata ? MatchMetadataMode.MATCH_METADATA : MatchMetadataMode.IGNORE_METADATA);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
        data.writeBoolean(this.isMatchByNBT());
        data.writeBoolean(this.isMatchByMetadata());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
        this.setMatchByNBT(data.readBoolean());
        this.setMatchByMetadata(data.readBoolean());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
        data.writeBoolean(this.isMatchByNBT());
        data.writeBoolean(this.isMatchByMetadata());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
        this.setMatchByNBT(data.readBoolean());
        this.setMatchByMetadata(data.readBoolean());
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.transferModeController.writeToNBT(data, "mode");
        this.redstoneModeController.writeToNBT(data, "redstone");
        this.getItemFilters().writeToNBT("invFilters", data);
        data.func_74757_a("matchByNBT", this.isMatchByNBT());
        data.func_74757_a("matchByMetadata", this.isMatchByMetadata());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.transferModeController.readFromNBT(data, "mode");
        this.redstoneModeController.readFromNBT(data, "redstone");
        if (data.func_74767_n("waitTillComplete")) {
            this.redstoneModeController.setCurrentState(EnumRedstoneMode.COMPLETE.ordinal());
        }
        if (data.func_74764_b("filters")) {
            NBTTagCompound filters = data.func_74775_l("filters");
            this.getItemFilters().readFromNBT("Items", filters);
        } else {
            this.getItemFilters().readFromNBT("invFilters", data);
        }
        this.setMatchByNBT(data.func_74767_n("matchByNBT"));
        this.setMatchByMetadata(data.func_74767_n("matchByMetadata"));
    }

    public static enum MatchMetadataMode implements IOverlayMultiButtonState
    {
        IGNORE_METADATA("railcraft.gui.item.loader.ignore_metadata", new ButtonTextureSet(64, 32, 32, 32)),
        MATCH_METADATA("railcraft.gui.item.loader.match_metadata", new ButtonTextureSet(32, 32, 32, 32));

        private final ToolTip tip;
        private final IButtonTextureSet overlay;

        private MatchMetadataMode(String label, IButtonTextureSet overlay) {
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
            this.overlay = overlay;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public IButtonTextureSet getOverlayTexture() {
            return this.overlay;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }

    public static enum MatchNBTMode implements IOverlayMultiButtonState
    {
        IGNORE_NBT("railcraft.gui.item.loader.ignore_nbt", new ButtonTextureSet(64, 0, 32, 32)),
        MATCH_NBT("railcraft.gui.item.loader.match_nbt", new ButtonTextureSet(32, 0, 32, 32));

        private final ToolTip tip;
        private final IButtonTextureSet overlay;

        private MatchNBTMode(String label, IButtonTextureSet overlay) {
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
            this.overlay = overlay;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public IButtonTextureSet getOverlayTexture() {
            return this.overlay;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }

    public static enum EnumRedstoneMode implements IMultiButtonState
    {
        IMMEDIATE("railcraft.gui.item.loader.immediate"),
        COMPLETE("railcraft.gui.item.loader.complete"),
        MANUAL("railcraft.gui.item.loader.manual"),
        PARTIAL("railcraft.gui.item.loader.partial");

        private final String label;
        private final ToolTip tip;

        private EnumRedstoneMode(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public StandardButtonTextureSets getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }

    public static enum EnumTransferMode implements IMultiButtonState
    {
        TRANSFER("railcraft.gui.item.loader.transfer"),
        STOCK("railcraft.gui.item.loader.stock"),
        EXCESS("railcraft.gui.item.loader.excess"),
        ALL("railcraft.gui.item.loader.all");

        private final String label;
        private final ToolTip tip;

        private EnumTransferMode(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

