/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileSwitchRouting
extends TileSwitchSecured
implements IRouter,
IRoutingTile {
    private final StandaloneInventory inv = new StandaloneInventory(1, this);
    private final MultiButtonController<IRouter.RoutingButtonState> routingController = new MultiButtonController(0, (IMultiButtonState[])IRouter.RoutingButtonState.values());
    private RoutingLogic logic;

    @Override
    public MultiButtonController<IRouter.RoutingButtonState> getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_ROUTING;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.field_145850_b)) {
            ItemStack current = player.field_71071_by.func_70448_g();
            if (current != null && current.func_77973_b() instanceof ItemRoutingTable && this.inv.func_70301_a(0) == null) {
                ItemStack copy = current.func_77946_l();
                copy.field_77994_a = 1;
                this.inv.func_70299_a(0, copy);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70296_d();
                }
                return true;
            }
            GuiHandler.openGui(EnumGui.ROUTING, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.resetLogic();
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.func_70301_a(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.func_70301_a(0));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }

    @Override
    public boolean shouldSwitch(ITrackSwitch switchTrack, EntityMinecart cart) {
        RoutingLogic logic = this.getLogic();
        if (logic != null && logic.isValid()) {
            return logic.matches(this, cart);
        }
        return false;
    }
}

