/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGeode
extends WorldGenerator {
    private static final int DISTANCE_OUTER_SQ = 64;
    private static final int DISTANCE_ORE_SQ = 25;
    private static final int DISTANCE_INNER_SQ = 16;
    private final Block blockStone;
    private final int meta;
    public final Set<Block> ores = new HashSet<Block>();
    private final Block blockOre;

    public WorldGenGeode(Block block, int meta) {
        this.blockStone = block;
        this.meta = meta;
        this.ores.add(Blocks.field_150365_q);
        this.ores.add(Blocks.field_150366_p);
        this.ores.add(Blocks.field_150352_o);
        this.ores.add(Blocks.field_150482_ag);
        this.ores.add(Blocks.field_150412_bA);
        this.ores.add(Blocks.field_150369_x);
        this.ores.add(Blocks.field_150449_bY);
        this.ores.add(Blocks.field_150450_ax);
        this.ores.add(Blocks.field_150439_ay);
        this.ores.addAll(OreDictPlugin.getOreBlocks());
        this.blockOre = BlockOre.getBlock();
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        for (int i = -8; i < 8; ++i) {
            for (int j = -8; j < 8; ++j) {
                for (int k = -8; k < 8; ++k) {
                    int distSq = i * i + j * j + k * k;
                    if (distSq <= 16) {
                        this.placeAir(world, rand, x + i, y + j, z + k);
                    } else if (distSq <= 64) {
                        this.placeStone(world, rand, x + i, y + j, z + k);
                    }
                    if (this.blockOre == null || distSq <= 16 || distSq > 25) continue;
                    this.placeOre(world, rand, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private void placeAir(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    private void placeStone(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_147465_d(x, y, z, this.blockStone, this.meta, 2);
        }
    }

    private void placeOre(World world, Random rand, int x, int y, int z) {
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y, z) == this.blockStone) {
            double chance = rand.nextDouble();
            if (chance <= 0.002 && EnumOre.DARK_DIAMOND.isEnabled()) {
                world.func_147465_d(x, y, z, this.blockOre, EnumOre.DARK_DIAMOND.ordinal(), 2);
            } else if (chance <= 0.004 && EnumOre.DARK_EMERALD.isEnabled()) {
                world.func_147465_d(x, y, z, this.blockOre, EnumOre.DARK_EMERALD.ordinal(), 2);
            } else if (chance <= 0.01 && EnumOre.DARK_LAPIS.isEnabled()) {
                world.func_147465_d(x, y, z, this.blockOre, EnumOre.DARK_LAPIS.ordinal(), 2);
            }
        }
    }

    private boolean isReplaceable(World world, int x, int y, int z) {
        Block existing = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (existing == null) {
            return false;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            return true;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, Blocks.field_150346_d)) {
            return true;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, Blocks.field_150351_n)) {
            return true;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, (Block)Blocks.field_150354_m)) {
            return true;
        }
        if (existing.func_149688_o() == Material.field_151586_h) {
            return true;
        }
        return this.ores.contains(existing);
    }
}

