/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.blocks;

import gcewing.sg.SGCraft;
import gcewing.sg.blocks.base.BaseBlock;
import gcewing.sg.guis.SGGui;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.IOrientationHandler;
import gcewing.sg.tileentities.PowerTE;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;

public class PowerBlock<TE extends PowerTE>
extends BaseBlock<TE> {
    PowerTE lastRemovedTE;

    public PowerBlock(Class teClass, IOrientationHandler orient) {
        super(SGCraft.machineMaterial, orient, teClass);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockAccess world, Vector3i pos, EnumFacing side) {
        return true;
    }

    @Override
    public void breakBlock(World world, Vector3i pos, IBlockState state) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof PowerTE) {
            this.lastRemovedTE = (PowerTE)te;
        }
        super.breakBlock(world, pos, state);
    }

    @Override
    public boolean onBlockActivated(World world, Vector3i pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGCraft.mod.openGui(player, (Enum)SGGui.PowerUnit, world, pos);
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(IBlockAccess world, Vector3i pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.getItemDropped(state, ((World)world).field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1);
        PowerTE te = this.lastRemovedTE;
        if (te != null && te.energyBuffer > 0.0) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.writeContentsToNBT(nbt);
            stack.func_77982_d(nbt);
            this.lastRemovedTE = null;
        }
        ret.add(stack);
        return ret;
    }

    @Override
    public void onBlockPlacedBy(World world, Vector3i pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        TileEntity t = this.getTileEntity((IBlockAccess)world, pos);
        if (t instanceof PowerTE) {
            PowerTE te = (PowerTE)t;
            NBTTagCompound nbt = stack.func_77978_p();
            if (te != null && nbt != null) {
                te.readContentsFromNBT(nbt);
            }
        }
    }
}

