/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.util.IChatComponent;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;

public class ClientClaimedChunks {

    public static class ChunkData {
        public static final DataOut.Serializer<ChunkData> SERIALIZER = (data, d) -> data.writeInt(d.flags);
        public static final DataIn.Deserializer<ChunkData> DESERIALIZER = data -> new ChunkData(Team.currentTeam, data.readInt());
        public static final int LOADED = 1;
        public Team team;
        private int flags;

        public ChunkData(Team t, int f) {
            this.team = t;
            this.flags = f;
        }

        public int hashCode() {
            return Objects.hash(this.team, this.flags);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o.getClass() == ChunkData.class) {
                ChunkData d = (ChunkData)o;
                return this.team.equals(d.team) && this.flags == d.flags;
            }
            return false;
        }

        public boolean isLoaded() {
            return Bits.getFlag(this.flags, 1);
        }

        public ChunkData setLoaded(boolean value) {
            this.flags = Bits.setFlag(this.flags, 1, value);
            return this;
        }

        public ChunkData setTeam(Team newTeam) {
            this.team = newTeam;
            return this;
        }

        public ChunkData copy() {
            return new ChunkData(this.team, this.flags);
        }

        public int getFlags() {
            return this.flags;
        }
    }

    public static class Team {
        private static Team currentTeam;
        public static final DataOut.Serializer<Team> SERIALIZER;
        public static final DataIn.Deserializer<Team> DESERIALIZER;
        public final short uid;
        public EnumTeamColor color;
        public IChatComponent nameComponent;
        public boolean isAlly;
        public boolean isMember;
        public final Int2ObjectMap<ChunkData> chunks = new Int2ObjectOpenHashMap();
        public final Object2ObjectMap<ChunkDimPos, ChunkData> chunkPos = new Object2ObjectOpenHashMap();

        public Team(short id) {
            this.uid = id;
        }

        static {
            SERIALIZER = (data, team) -> {
                data.writeShort(team.uid);
                data.writeTextComponent(team.nameComponent);
                EnumTeamColor.NAME_MAP.write(data, team.color);
                data.writeBoolean(team.isAlly);
                data.writeBoolean(team.isMember);
                data.writeMap(team.chunkPos, DataOut.CHUNK_DIM_POS, ChunkData.SERIALIZER);
                data.writeMap(team.chunks, DataOut.INT, ChunkData.SERIALIZER);
            };
            DESERIALIZER = data -> {
                Team team = new Team(data.readShort());
                team.nameComponent = data.readTextComponent();
                team.color = EnumTeamColor.NAME_MAP.read(data);
                team.isAlly = data.readBoolean();
                team.isMember = data.readBoolean();
                currentTeam = team;
                data.readMap(team.chunkPos, DataIn.CHUNK_DIM_POS, ChunkData.DESERIALIZER);
                data.readMap(team.chunks, DataIn.INT, ChunkData.DESERIALIZER);
                return team;
            };
        }
    }
}

