/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.misc;

import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.misc.NameMap;

public enum EnumScreenPosition implements IStringSerializable
{
    CENTER("center", 0, 0),
    TOP("top", 0, -1),
    BOTTOM("bottom", 0, 1),
    LEFT("left", -1, 0),
    RIGHT("right", 1, 0),
    TOP_LEFT("top_left", -1, -1),
    TOP_RIGHT("top_right", 1, -1),
    BOTTOM_LEFT("bottom_left", -1, 1),
    BOTTOM_RIGHT("bottom_right", 1, 1);

    public static final NameMap<EnumScreenPosition> NAME_MAP;
    private final String name;
    public final int offsetX;
    public final int offsetY;

    private EnumScreenPosition(String n2, int ox, int oy) {
        this.name = n2;
        this.offsetX = ox;
        this.offsetY = oy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getX(int screenWidth, int width, int offset) {
        int n;
        switch (this.offsetX) {
            case -1: {
                n = offset;
                break;
            }
            case 1: {
                n = (screenWidth - width) / 2;
                break;
            }
            default: {
                n = screenWidth - width - offset;
            }
        }
        return n;
    }

    public int getY(int screenHeight, int height, int offset) {
        int n;
        switch (this.offsetY) {
            case -1: {
                n = offset;
                break;
            }
            case 1: {
                n = (screenHeight - height) / 2;
                break;
            }
            default: {
                n = screenHeight - height - offset;
            }
        }
        return n;
    }

    static {
        NAME_MAP = NameMap.create(CENTER, EnumScreenPosition.values());
    }
}

