/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilitiesCommon;
import serverutils.lib.data.Action;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageMyTeamAction
extends MessageToServer {
    private ResourceLocation action;
    private NBTTagCompound nbt;

    public MessageMyTeamAction() {
    }

    public MessageMyTeamAction(ResourceLocation id, NBTTagCompound data) {
        this.action = id;
        this.nbt = data;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.action);
        data.writeNBT(this.nbt);
    }

    @Override
    public void readData(DataIn data) {
        this.action = data.readResourceLocation();
        this.nbt = data.readNBT();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        ForgePlayer p;
        Action a = ServerUtilitiesCommon.TEAM_GUI_ACTIONS.get(this.action);
        if (a != null && (p = Universe.get().getPlayer((ICommandSender)player)).hasTeam() && a.getType(p, this.nbt).isEnabled()) {
            a.onAction(p, this.nbt);
        }
    }
}

