/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotBuilder;

public class ModuleRailer
extends ModuleWorker
implements ISuppliesModule {
    private boolean hasGeneratedAngles = false;
    private float[] railAngles;

    public ModuleRailer(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBuilder(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.RAILER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 100;
    }

    @Override
    public boolean work() {
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        ArrayList<Integer[]> pos = this.getValidRailPositions(x, y, z);
        if (this.doPreWork()) {
            boolean valid = false;
            for (int i = 0; i < pos.size(); ++i) {
                if (!this.tryPlaceTrack(pos.get(i)[0], pos.get(i)[1], pos.get(i)[2], false)) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.startWorking(12);
            } else {
                boolean front = false;
                for (int i = 0; i < pos.size(); ++i) {
                    if (!BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)pos.get(i)[0], (int)pos.get(i)[1], (int)pos.get(i)[2])) continue;
                    front = true;
                    break;
                }
                if (!front) {
                    this.turnback();
                }
            }
            return true;
        }
        this.stopWorking();
        for (int i = 0; i < pos.size() && !this.tryPlaceTrack(pos.get(i)[0], pos.get(i)[1], pos.get(i)[2], true); ++i) {
        }
        return false;
    }

    protected ArrayList<Integer[]> getValidRailPositions(int x, int y, int z) {
        ArrayList<Integer[]> lst = new ArrayList<Integer[]>();
        if (y >= this.getCart().y()) {
            lst.add(new Integer[]{x, y + 1, z});
        }
        lst.add(new Integer[]{x, y, z});
        lst.add(new Integer[]{x, y - 1, z});
        return lst;
    }

    protected boolean validRail(Item item) {
        return Block.func_149634_a((Item)item) == Blocks.field_150448_aq;
    }

    private boolean tryPlaceTrack(int i, int j, int k, boolean flag) {
        if (this.isValidForTrack(i, j, k, true)) {
            for (int l = 0; l < this.getInventorySize(); ++l) {
                if (this.getStack(l) == null || !this.validRail(this.getStack(l).func_77973_b())) continue;
                if (flag) {
                    this.getCart().field_70170_p.func_147449_b(i, j, k, Block.func_149634_a((Item)this.getStack(l).func_77973_b()));
                    if (!this.getCart().hasCreativeSupplies()) {
                        --this.getStack((int)l).field_77994_a;
                        if (this.getStack((int)l).field_77994_a == 0) {
                            this.setStack(l, null);
                        }
                        this.getCart().func_70296_d();
                    }
                }
                return true;
            }
            this.turnback();
            return true;
        }
        return false;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateRails();
    }

    private void calculateRails() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        int valid = 0;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null || !this.validRail(this.getStack(i).func_77973_b())) continue;
            valid = (byte)(valid + 1);
        }
        this.updateDw(0, valid);
    }

    public int getRails() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getRailCount();
        }
        return this.getDw(0);
    }

    public float getRailAngle(int i) {
        if (!this.hasGeneratedAngles) {
            this.railAngles = new float[this.getInventorySize()];
            for (int j = 0; j < this.getInventorySize(); ++j) {
                this.railAngles[j] = this.getCart().field_70146_Z.nextFloat() / 2.0f - 0.25f;
            }
            this.hasGeneratedAngles = true;
        }
        return this.railAngles[i];
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.calculateRails();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || !this.validRail(item.func_77973_b())) continue;
            return true;
        }
        return false;
    }
}

