/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class MazeHandlerVisitor
extends ClassVisitor {
    private static final Set<String> mutators = ImmutableSet.of((Object)"putToHashMap", (Object)"putToHashMapRaw", (Object)"removeFromHashMap", (Object)"clearHashMap");
    private String className;

    public MazeHandlerVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.className, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("writeNBT") && desc.equals("()Lnet/minecraft/nbt/NBTTagCompound;")) {
            TC4Transformer.log.debug("Replacing writeNBT()Lnet/minecraft/nbt/NBTTagCompound;");
            ASMUtils.writeMethodDeflected("net/glease/tc4tweak/asm/ASMCallhookServer", "writeMazeToNBT", mv, null, desc);
            return null;
        }
        if (mutators.contains(name)) {
            TC4Transformer.log.debug("Transforming {}{}", new Object[]{name, desc});
            return new MarkDirtyMethodVisitor(mv);
        }
        if ("loadMaze".equals(name)) {
            TC4Transformer.log.debug("Transforming {}{}", new Object[]{name, desc});
            return new ResetDirtyMethodVisitor(mv, Type.getReturnType((String)desc).getOpcode(172));
        }
        if ("saveMaze".equals(name)) {
            TC4Transformer.log.debug("Transforming {}{}", new Object[]{name, desc});
            return new SaveMazeMethodVisitor(mv);
        }
        return mv;
    }

    public void visitEnd() {
        this.cv.visitField(10, "tc4tweaks$dirty", "Z", null, (Object)false).visitEnd();
        super.visitEnd();
    }

    private class SaveMazeMethodVisitor
    extends MethodVisitor {
        public SaveMazeMethodVisitor(MethodVisitor mv) {
            super(MazeHandlerVisitor.this.api, mv);
        }

        public void visitCode() {
            super.visitCode();
            TC4Transformer.log.trace("Add dirty check");
            Label l0 = new Label();
            this.mv.visitFieldInsn(178, MazeHandlerVisitor.this.className, "tc4tweaks$dirty", "Z");
            this.mv.visitJumpInsn(154, l0);
            this.mv.visitInsn(177);
            this.mv.visitLabel(l0);
            this.mv.visitInsn(3);
            this.mv.visitFieldInsn(179, MazeHandlerVisitor.this.className, "tc4tweaks$dirty", "Z");
            this.mv.visitFrame(3, 0, null, 0, null);
        }
    }

    private class ResetDirtyMethodVisitor
    extends MethodVisitor {
        private final int returnOpcode;

        public ResetDirtyMethodVisitor(MethodVisitor mv, int returnOpcode) {
            super(MazeHandlerVisitor.this.api, mv);
            this.returnOpcode = returnOpcode;
        }

        public void visitInsn(int opcode) {
            if (opcode == this.returnOpcode) {
                TC4Transformer.log.trace("Add clear dirty");
                this.mv.visitInsn(3);
                this.mv.visitFieldInsn(179, MazeHandlerVisitor.this.className, "tc4tweaks$dirty", "Z");
            }
            super.visitInsn(opcode);
        }
    }

    private class MarkDirtyMethodVisitor
    extends MethodVisitor {
        public MarkDirtyMethodVisitor(MethodVisitor mv) {
            super(MazeHandlerVisitor.this.api, mv);
        }

        public void visitCode() {
            super.visitCode();
            TC4Transformer.log.trace("Add set dirty");
            this.mv.visitInsn(4);
            this.mv.visitFieldInsn(179, MazeHandlerVisitor.this.className, "tc4tweaks$dirty", "Z");
        }
    }
}

