/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MessageItemShoutout
implements IMessage {
    int dim;
    int playerid;
    ItemStack item;

    public MessageItemShoutout() {
    }

    public MessageItemShoutout(EntityPlayer player, ItemStack stack) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.item = stack;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.playerid = buf.readInt();
        this.item = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.playerid);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
    }

    public static class Handler
    implements IMessageHandler<MessageItemShoutout, IMessage> {
        public IMessage onMessage(MessageItemShoutout message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerid);
            if (!(player instanceof EntityPlayer)) {
                return null;
            }
            for (EntityPlayer onlineP : world.field_73010_i) {
                onlineP.func_145747_a((IChatComponent)new ChatComponentTranslation("TG.chattext.showItem", new Object[]{((EntityPlayer)player).getDisplayName(), message.item.func_151000_E()}));
            }
            return null;
        }
    }
}

