/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network.old;

import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.api.IActiveAbility;
import travellersgear.api.TravellersGearAPI;
import travellersgear.common.network.old.AbstractPacket;
import travellersgear.common.util.ModCompatability;

public class PacketActiveAbility
extends AbstractPacket {
    int dim;
    int playerid;
    int slot;

    public PacketActiveAbility() {
    }

    public PacketActiveAbility(EntityPlayer player, int slot) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.slot = slot;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        buffer.writeInt(this.slot);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.slot = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer p) {
    }

    @Override
    public void handleServerSide(EntityPlayer p) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return;
        }
        Entity ent = world.func_73045_a(this.playerid);
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ent;
        PacketActiveAbility.performAbility(player, this.slot);
    }

    public static void performAbility(EntityPlayer player, int slot) {
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ItemStack[] mainInv = player.field_71071_by.field_70462_a;
                PacketActiveAbility.activateItem(mainInv[slot], player, true);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                ItemStack[] armorInv = player.field_71071_by.field_70460_b;
                PacketActiveAbility.activateItem(armorInv[slot - 9], player, false);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                IInventory baubInv = BaublesApi.getBaubles(player);
                PacketActiveAbility.activateItem(baubInv.func_70301_a(slot - 4 - 9), player, false);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                ItemStack[] tgInv = TravellersGearAPI.getExtendedInventory(player);
                PacketActiveAbility.activateItem(tgInv[slot - 8 - 9], player, false);
                TravellersGearAPI.setExtendedInventory(player, tgInv);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                IInventory mariInv = ModCompatability.getMariInventory(player);
                PacketActiveAbility.activateItem(mariInv.func_70301_a(slot - 12 - 9), player, false);
                break;
            }
            case 24: 
            case 25: {
                IInventory tconInv = ModCompatability.getTConArmorInv(player);
                PacketActiveAbility.activateItem(tconInv.func_70301_a(slot - 15 - 9), player, false);
                break;
            }
        }
    }

    static void activateItem(ItemStack stack, EntityPlayer player, boolean e) {
        if (stack != null && stack.func_77973_b() instanceof IActiveAbility && ((IActiveAbility)stack.func_77973_b()).canActivate(player, stack, e)) {
            ((IActiveAbility)stack.func_77973_b()).activate(player, stack);
        }
    }
}

