/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFGenHugeWaterLily;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMosquitoSwarm;
import twilightforest.world.TFGenHugeLilyPad;
import twilightforest.world.TFWorld;

public class TFBiomeSwamp
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 20;
    Random monsterRNG = new Random(53439L);
    ArrayList<BiomeGenBase.SpawnListEntry> emptyList = new ArrayList();
    WorldGenVines worldgenvines = new WorldGenVines();
    WorldGenerator hugeLilyPadGen = new TFGenHugeLilyPad();
    WorldGenerator hugeWaterLilyGen = new TFGenHugeWaterLily();

    public TFBiomeSwamp(int i) {
        super(i);
        this.field_76750_F = 0.8f;
        this.field_76751_G = 0.9f;
        this.getTFBiomeDecorator().setDeadBushPerChunk(1);
        this.getTFBiomeDecorator().setMushroomsPerChunk(8);
        this.getTFBiomeDecorator().setReedsPerChunk(10);
        this.getTFBiomeDecorator().setClayPerChunk(1);
        this.getTFBiomeDecorator().setTreesPerChunk(2);
        this.getTFBiomeDecorator().setWaterlilyPerChunk(20);
        this.field_76759_H = 14745518;
        this.getTFBiomeDecorator().canopyPerChunk = -999.0f;
        this.getTFBiomeDecorator().lakesPerChunk = 2;
        this.getTFBiomeDecorator().mangrovesPerChunk = 3;
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTFMosquitoSwarm.class, 10, 1, 1));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenShrub(3, 0);
        }
        return this.field_76763_Q;
    }

    @Override
    public WorldGenerator func_76730_b(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass((Block)Blocks.field_150329_H, 2);
        }
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass(TFBlocks.plant, 4);
        }
        return new WorldGenTallGrass((Block)Blocks.field_150329_H, 1);
    }

    public void func_76728_a(World par1World, Random par2Random, int par3, int par4) {
        int z;
        int y;
        int x;
        int i;
        super.func_76728_a(par1World, par2Random, par3, par4);
        for (i = 0; i < 50; ++i) {
            int j = par3 + par2Random.nextInt(16) + 8;
            byte byte0 = (byte)TFWorld.SEALEVEL;
            int k = par4 + par2Random.nextInt(16) + 8;
            this.worldgenvines.func_76484_a(par1World, par2Random, j, (int)byte0, k);
        }
        for (i = 0; i < 25; ++i) {
            x = par3 + par2Random.nextInt(16) + 8;
            y = TFWorld.SEALEVEL;
            z = par4 + par2Random.nextInt(16) + 8;
            this.hugeLilyPadGen.func_76484_a(par1World, par2Random, x, y, z);
        }
        for (i = 0; i < 2; ++i) {
            x = par3 + par2Random.nextInt(16) + 8;
            y = TFWorld.SEALEVEL;
            z = par4 + par2Random.nextInt(16) + 8;
            this.hugeWaterLilyGen.func_76484_a(par1World, par2Random, x, y, z);
        }
    }

    public int func_150558_b(int x, int y, int z) {
        double var1 = MathHelper.func_76131_a((float)this.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerGrass.func_77480_a((double)var1, (double)var3) & 0xFEFEFE) + 0x4E0E4E) / 2;
    }

    public int func_150571_c(int x, int y, int z) {
        double var1 = MathHelper.func_76131_a((float)this.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerFoliage.func_77470_a((double)var1, (double)var3) & 0xFEFEFE) + 0x4E0E4E) / 2;
    }

    public List<BiomeGenBase.SpawnListEntry> func_76747_a(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            return this.monsterRNG.nextInt(20) == 0 ? this.field_76761_J : this.emptyList;
        }
        return par1EnumCreatureType == EnumCreatureType.creature ? this.field_76762_K : (par1EnumCreatureType == EnumCreatureType.waterCreature ? this.field_76755_L : (par1EnumCreatureType == EnumCreatureType.ambient ? this.field_82914_M : null));
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressLich;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.field_72995_K && world.func_72820_D() % 60L == 0L) {
            PotionEffect currentHunger = player.func_70660_b(Potion.field_76438_s);
            int hungerLevel = currentHunger != null ? currentHunger.func_76458_c() + 1 : 1;
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 100, hungerLevel));
            if (world.field_73012_v.nextInt(4) == 0) {
                TFFeature.labyrinth.trySpawnHintMonster(world, player);
            }
        }
    }
}

