/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotArmor;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotBooster;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotTrash;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotViewCell;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryBooster;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryCrafting;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryTrash;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryViewCell;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMEInventoryUpdate;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class ContainerWirelessCraftingTerminal
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack>,
IAEAppEngInventory,
IContainerCraftingPacket,
IViewCellStorage {
    private final ItemStack containerstack;
    public final WCTInventoryCrafting craftingGrid;
    public final WCTInventoryViewCell viewCellInventory;
    public final WCTInventoryBooster boosterInventory;
    public final WCTInventoryMagnet magnetInventory;
    public final WCTInventoryTrash trashInventory;
    public final InventoryPlayer inventoryPlayer;
    public ItemStack[] craftMatrixInventory;
    private final World worldObj;
    private final EntityPlayer player;
    public static final int HOTBAR_START = 2;
    public static final int HOTBAR_END = 10;
    public static final int INV_START = 11;
    public static final int INV_END = 37;
    public static final int ARMOR_START = 38;
    public static final int ARMOR_END = 41;
    public static final int CRAFT_GRID_START = 42;
    public static final int CRAFT_GRID_END = 50;
    public static final int CRAFT_RESULT = 51;
    public static final int VIEW_CELL_START = 52;
    public static final int VIEW_CELL_END = 56;
    public static final int BOOSTER_INDEX = 1;
    public static final int MAGNET_INDEX = 57;
    public static int CRAFTING_SLOT_X_POS = 80;
    public static int CRAFTING_SLOT_Y_POS = 83;
    private SlotBooster boosterSlot;
    private final SlotMagnet magnetSlot;
    private final Slot[] hotbarSlot;
    private final Slot[] inventorySlot;
    private final SlotArmor[] armorSlot;
    private final SlotCraftingMatrix[] craftMatrixSlot;
    private final SlotCraftingTerm craftingSlot;
    private final SlotViewCell[] viewCellSlot;
    public SlotTrash trashSlot;
    private int firstCraftingSlotNumber = -1;
    private int lastCraftingSlotNumber = -1;
    private final WirelessTerminalGuiObject obj;
    private double powerMultiplier = 0.5;
    private final IPortableCell civ;
    private int ticks = 0;
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final IConfigManager clientCM;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private final AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final IWirelessCraftingTerminalItem thisItem;
    private final IGridNode networkNode;
    private IRecipe currentRecipe;

    public ContainerWirelessCraftingTerminal(EntityPlayer player, InventoryPlayer inventoryPlayer) {
        super(inventoryPlayer, (Object)ContainerWirelessCraftingTerminal.getGuiObject(RandomUtils.getWirelessTerm(inventoryPlayer), player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
        int j;
        int i;
        IGridNode node;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.setCustomName("WCTContainer");
        this.boosterInventory = new WCTInventoryBooster(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.magnetInventory = new WCTInventoryMagnet(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.trashInventory = new WCTInventoryTrash(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.containerstack = RandomUtils.getWirelessTerm(inventoryPlayer);
        this.thisItem = (IWirelessCraftingTerminalItem)this.containerstack.func_77973_b();
        this.worldObj = player.field_70170_p;
        this.craftingGrid = new WCTInventoryCrafting((Container)this, 3, 3, this.containerstack);
        this.viewCellInventory = new WCTInventoryViewCell(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.inventoryPlayer = inventoryPlayer;
        this.player = player;
        this.craftMatrixInventory = new ItemStack[9];
        this.hotbarSlot = new Slot[9];
        this.inventorySlot = new Slot[27];
        this.armorSlot = new SlotArmor[4];
        this.craftMatrixSlot = new SlotCraftingMatrix[9];
        this.viewCellSlot = new SlotViewCell[5];
        this.obj = ContainerWirelessCraftingTerminal.getGuiObject(this.containerstack, player, this.worldObj, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        this.civ = this.obj;
        this.networkNode = node = this.obj.getGridNode(ForgeDirection.UNKNOWN);
        if (Platform.isServer()) {
            this.serverCM = this.civ.getConfigManager();
            this.monitor = this.civ.getItemInventory();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler)this.monitor);
                if (this.civ instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)this.civ);
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.func_75146_a((Slot)new SlotInaccessible((IInventory)new AppEngInternalInventory(null, 1), 0, -1000, -1000));
        if (Reference.WCT_BOOSTER_ENABLED) {
            this.boosterSlot = new SlotBooster(this.boosterInventory, 0, 134, -20);
            this.func_75146_a((Slot)this.boosterSlot);
        } else {
            this.func_75146_a((Slot)new SlotInaccessible((IInventory)new AppEngInternalInventory(null, 1), 0, -1000, -1000));
        }
        for (int i2 = 0; i2 < 9; ++i2) {
            this.hotbarSlot[i2] = player.field_71071_by.func_70301_a(i2) != null && player.field_71071_by.func_70301_a(i2).func_77973_b() == this.thisItem ? new SlotDisabled((IInventory)this.inventoryPlayer, i2, i2 * 18 + 8, 58) : new SlotPlayerHotBar((IInventory)this.inventoryPlayer, i2, i2 * 18 + 8, 58);
            this.func_75146_a(this.hotbarSlot[i2]);
        }
        int k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.inventorySlot[k] = player.field_71071_by.func_70301_a(j + i * 9 + 9) != null && player.field_71071_by.func_70301_a(j + i * 9 + 9).func_77973_b() == this.thisItem ? new SlotDisabled((IInventory)this.inventoryPlayer, j + i * 9 + 9, j * 18 + 8, i * 18) : new SlotPlayerInv((IInventory)this.inventoryPlayer, j + i * 9 + 9, j * 18 + 8, i * 18);
                this.func_75146_a(this.inventorySlot[k]);
                ++k;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.armorSlot[i] = new SlotArmor(this.player, (IInventory)this.inventoryPlayer, 39 - i, 8, i * 18 - 76, i);
            this.func_75146_a((Slot)this.armorSlot[i]);
        }
        k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.craftMatrixSlot[k] = new SlotCraftingMatrix((Container)this, (IInventory)this.craftingGrid, j + i * 3, 80 + j * 18, i * 18 - 76);
                this.func_75146_a((Slot)this.craftMatrixSlot[k]);
                if (k == 0) {
                    this.firstCraftingSlotNumber = this.craftMatrixSlot[k].field_75222_d;
                }
                ++k;
            }
        }
        this.lastCraftingSlotNumber = this.craftMatrixSlot[8].field_75222_d;
        this.craftingSlot = new SlotCraftingTerm(this.getPlayerInv().field_70458_d, this.getActionSource(), this.getPowerSource(), (IStorageMonitorable)this.obj, (IInventory)this.craftingGrid, (IInventory)this.craftingGrid, (IInventory)this.output, 174, -58, (IContainerCraftingPacket)this);
        this.func_75146_a((Slot)this.craftingSlot);
        for (i = 0; i < 5; ++i) {
            this.viewCellSlot[i] = new SlotViewCell(this.getViewCellStorage(), i, 207, i * 18 + 8, inventoryPlayer);
            this.func_75146_a((Slot)this.viewCellSlot[i]);
        }
        this.magnetSlot = new SlotMagnet(this.magnetInventory, 152, -20);
        this.func_75146_a((Slot)this.magnetSlot);
        this.trashSlot = new SlotTrash(this.trashInventory, 80, -20, player);
        this.trashSlot.setContainer(this);
        this.func_75146_a((Slot)this.trashSlot);
        this.updateCraftingMatrix();
        this.func_75130_a((IInventory)this.craftingGrid);
        this.thisItem.checkForBooster(this.containerstack);
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer((AEBaseContainer)this);
            return super.func_75146_a(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "] for WCT Container instead of AppEngSlot.");
    }

    public boolean func_94531_b(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    private IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!((IRecipe)recipe).func_77569_a(craftMatrix, worldIn)) continue;
            return (IRecipe)recipe;
        }
        return null;
    }

    public void func_75130_a(IInventory iinv) {
        ContainerNull cn = new ContainerNull();
        InventoryCrafting craftingInv = new InventoryCrafting((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            craftingInv.func_70299_a(x, this.craftMatrixSlot[x].func_75211_c());
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(craftingInv, this.getPlayerInv().field_70458_d.field_70170_p)) {
            this.currentRecipe = this.findMatchingRecipe(craftingInv, this.getPlayerInv().field_70458_d.field_70170_p);
        }
        if (this.currentRecipe == null) {
            this.craftingSlot.func_75215_d(null);
        } else {
            ItemStack craftingResult = this.currentRecipe.func_77572_b(craftingInv);
            this.craftingSlot.func_75215_d(craftingResult);
        }
        this.writeToNBT("crafting");
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                        break;
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand == null) {
                            s.func_75215_d(null);
                            break;
                        }
                        s.func_75215_d(hand.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand == null) break;
                        Object is = hand.func_77946_l();
                        ((ItemStack)is).field_77994_a = 1;
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        Object is = s.func_75211_c();
                        if (is != null) {
                            if (hand == null) {
                                --((ItemStack)is).field_77994_a;
                            } else if (hand.func_77969_a((ItemStack)is)) {
                                ((ItemStack)is).field_77994_a = Math.min(is.func_77976_d(), ((ItemStack)is).field_77994_a + 1);
                            } else {
                                is = hand.func_77946_l();
                                ((ItemStack)is).field_77994_a = 1;
                            }
                            s.func_75215_d((ItemStack)is);
                            break;
                        }
                        if (hand == null) break;
                        is = hand.func_77946_l();
                        ((ItemStack)is).field_77994_a = 1;
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                LinkedList<Slot> from = new LinkedList<Slot>();
                for (Object j : this.field_75151_b) {
                    if (!(j instanceof Slot) || j.getClass() != s.getClass()) continue;
                    from.add((Slot)j);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.getTargetStack();
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.getItemStack();
                ais.setStackSize((long)myItem.func_77976_d());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                myItem.field_77994_a = (int)ais.getStackSize();
                myItem = adp.simulateAdd(myItem);
                if (myItem != null) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.field_77994_a);
                }
                if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) break;
                adp.addItems(ais.getItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg == null) break;
                IAEItemStack ais = AEApi.instance().storage().createItemStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.removeItems(1, extracted.getItemStack(), null);
                if (fail == null) {
                    this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (item != null) {
                    if (item.field_77994_a >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.isSameItemPrecise((ItemStack)slotItem.getItemStack(), (ItemStack)item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais == null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.addItems(ais.getItemStack());
                if (fail != null) {
                    this.getCellInventory().injectItems((IAEStack)ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize((long)ais.getItemStack().func_77976_d());
                    ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.getItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.getItemStack());
                } else {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getItemStack().func_77976_d();
                    ais.setStackSize(maxSize);
                    ais = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    }
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.getItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                ItemStack is = player.field_71071_by.func_70445_o();
                --is.field_77994_a;
                if (is.field_77994_a <= 0) {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                ItemStack is = slotItem.getItemStack();
                is.field_77994_a = is.func_77976_d();
                player.field_71071_by.func_70437_b(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.getItemStack();
                    ais.setStackSize((long)myItem.func_77976_d());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    myItem.field_77994_a = (int)ais.getStackSize();
                    myItem = adp.simulateAdd(myItem);
                    if (myItem != null) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.field_77994_a);
                    }
                    if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.getItemStack());
                }
                break;
            }
        }
    }

    private void updateCraftingMatrix() {
        if (!this.containerstack.func_77942_o()) {
            this.containerstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound stack = this.containerstack.func_77978_p();
        this.readMatrixNBT(stack);
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid.func_70299_a(i, this.craftMatrixInventory[i]);
        }
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean useRealItems() {
        return true;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player") || name.equals("container.inventory")) {
            return this.getInventoryPlayer();
        }
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return null;
    }

    public IInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.viewCellSlot.length];
        for (int x = 0; x < this.viewCellSlot.length; ++x) {
            list[x] = this.viewCellSlot[x].func_75211_c();
        }
        return list;
    }

    public SlotViewCell getCellViewSlot(int index) {
        return this.viewCellSlot[index];
    }

    public static WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public void func_75142_b() {
        ++this.ticks;
        if (this.ticks > 10) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            } else {
                this.civ.extractAEPower((double)((int)(0.5 * (double)this.ticks)), Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
            this.ticks = 0;
        }
        if (Platform.isServer()) {
            if (this.monitor != this.civ.getItemInventory()) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (Object crafter : this.field_75149_d) {
                    try {
                        NetworkHandler.instance.sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        WCTLog.debug(e.getMessage(), new Object[0]);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList monitorCache = this.monitor.getStorageList();
                    PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                    for (IAEItemStack is : this.items) {
                        IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendItem(is);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (Object c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException e) {
                    WCTLog.debug(e.getMessage(), new Object[0]);
                }
            }
        }
        if (!this.isInRange()) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            }
            if (!this.networkIsPowered()) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a((IChatComponent)new ChatComponentText(LocaleHandler.NoNetworkPower.getLocal()));
                }
                this.setValidContainer(false);
            }
        } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
            if (this.isValidContainer()) {
                this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.CommunicationError.get());
            }
            this.setValidContainer(false);
        } else {
            this.setPowerMultiplier(AEConfig.instance.wireless_getDrainRate(this.obj.getRange()));
        }
        super.func_75142_b();
    }

    public boolean isBoosterInstalled() {
        Slot slot = this.func_75147_a(this.boosterInventory, 0);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.func_75147_a(this.boosterInventory, 0).func_75216_d();
        if (hasStack) {
            Item boosterSlotContents = this.func_75147_a(this.boosterInventory, 0).func_75211_c().func_77973_b();
            return boosterSlotContents instanceof ItemInfinityBooster;
        }
        return false;
    }

    public boolean isMagnetInstalled() {
        Slot slot = this.func_75147_a(this.magnetInventory, 57);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.func_75147_a(this.magnetInventory, 57).func_75216_d();
        if (hasStack) {
            Item magnetSlotContents = this.func_75147_a(this.magnetInventory, 57).func_75211_c().func_77973_b();
            return magnetSlotContents instanceof ItemMagnet;
        }
        return false;
    }

    protected boolean isInRange() {
        return this.obj.rangeCheck(Reference.WCT_BOOSTER_ENABLED && this.isBoosterInstalled());
    }

    protected boolean networkIsPowered() {
        IGrid grid;
        IActionHost host = this.getActionHost();
        if (host != null && (grid = this.obj.getTargetGrid()) != null) {
            IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            return eg.isNetworkPowered();
        }
        return false;
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    public boolean isPowered() {
        double pwr = this.thisItem.getAECurrentPower(this.containerstack);
        return pwr > 0.0;
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    private void readMatrixNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.func_150295_c("CraftingMatrix", 10);
        this.craftMatrixInventory = new ItemStack[9];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftMatrixInventory.length) continue;
            this.craftMatrixInventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public void writeToNBT(String which) {
        if (!this.containerstack.func_77942_o()) {
            this.containerstack.func_77982_d(new NBTTagCompound());
        }
        switch (which) {
            case "booster": {
                this.boosterInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "crafting": {
                this.craftingGrid.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "viewCell": {
                this.viewCellInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "magnet": {
                this.magnetInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            case "trash": {
                this.trashInventory.writeNBT(this.containerstack.func_77978_p());
                break;
            }
            default: {
                this.boosterInventory.writeNBT(this.containerstack.func_77978_p());
                this.craftingGrid.writeNBT(this.containerstack.func_77978_p());
                this.viewCellInventory.writeNBT(this.containerstack.func_77978_p());
                this.magnetInventory.writeNBT(this.containerstack.func_77978_p());
                this.trashInventory.writeNBT(this.containerstack.func_77978_p());
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        AppEngSlot clickSlot = (AppEngSlot)this.field_75151_b.get(idx);
        ItemStack tis = clickSlot.func_75211_c();
        if (tis == null || tis == this.containerstack) {
            return null;
        }
        if (this.isInInventory(idx) || this.isInHotbar(idx)) {
            if (tis.func_77973_b() instanceof ItemArmor) {
                int type = ((ItemArmor)tis.func_77973_b()).field_77881_a;
                if (this.func_75135_a(tis, 38 + type, 38 + type + 1, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.func_77973_b() instanceof ItemInfinityBooster) {
                if (this.func_75135_a(tis, 1, 2, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.func_77973_b() instanceof ItemMagnet) {
                if (this.func_75135_a(tis, 57, 58, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (AEApi.instance().definitions().items().viewCell().isSameAs(tis) && this.func_75135_a(tis.func_77946_l(), 52, 57, false)) {
                if (tis.field_77994_a > 1) {
                    --tis.field_77994_a;
                } else {
                    clickSlot.clearStack();
                }
                return null;
            }
        }
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.field_75151_b) {
            if (!(is instanceof InternalSlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return null;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            AppEngSlot cs;
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                tis = this.shiftStoreItem(tis);
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)e;
                    if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)e;
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && tis != null) {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)e;
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.isSameItemPrecise((ItemStack)destination, (ItemStack)tis)) {
                        return null;
                    }
                    if (destination != null) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    cs.func_75218_e();
                    this.updateSlot((Slot)cs);
                    return null;
                }
            }
            if (tis != null) {
                int placeAble;
                for (Slot slot : selectedSlots) {
                    ItemStack t;
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d() || !Platform.isSameItemPrecise((ItemStack)tis, (ItemStack)(t = slot.func_75211_c()))) continue;
                    int maxSize = t.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                        placeAble = tis.field_77994_a;
                    }
                    t.field_77994_a += placeAble;
                    tis.field_77994_a -= placeAble;
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot((Slot)clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                    if (slot.func_75216_d()) {
                        ItemStack t = slot.func_75211_c();
                        if (!Platform.isSameItemPrecise((ItemStack)t, (ItemStack)tis)) continue;
                        int maxSize = t.func_77976_d();
                        if (slot.func_75219_a() < maxSize) {
                            maxSize = slot.func_75219_a();
                        }
                        if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                            placeAble = tis.field_77994_a;
                        }
                        t.field_77994_a += placeAble;
                        tis.field_77994_a -= placeAble;
                        if (tis.field_77994_a <= 0) {
                            clickSlot.func_75215_d(null);
                            slot.func_75218_e();
                            this.updateSlot((Slot)clickSlot);
                            this.updateSlot(slot);
                            return null;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize = tis.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    ItemStack tmp = tis.func_77946_l();
                    if (tmp.field_77994_a > maxSize) {
                        tmp.field_77994_a = maxSize;
                    }
                    tis.field_77994_a -= tmp.field_77994_a;
                    slot.func_75215_d(tmp);
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot((Slot)clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.func_75215_d(tis != null ? tis.func_77946_l() : null);
        }
        this.updateSlot((Slot)clickSlot);
        return null;
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.civ == null) {
            return input;
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.civ, (IAEStack)AEApi.instance().storage().createItemStack(input), (BaseActionSource)this.getActionSource());
        if (ais == null) {
            return null;
        }
        return ais.getItemStack();
    }

    private boolean isInHotbar(@Nonnull int index) {
        return index >= 2 && index <= 10;
    }

    private boolean isInInventory(@Nonnull int index) {
        return index >= 11 && index <= 37;
    }

    private boolean isInArmorSlot(@Nonnull int index) {
        return index >= 38 && index <= 41;
    }

    private boolean isInBoosterSlot(@Nonnull int index) {
        return index == 1;
    }

    private boolean isCraftResult(@Nonnull int index) {
        return index == 51;
    }

    private boolean isInCraftMatrix(@Nonnull int index) {
        return index >= 42 && index <= 50;
    }

    private boolean notArmorOrBooster(ItemStack is) {
        return !(is.func_77973_b() instanceof ItemInfinityBooster) && !(is.func_77973_b() instanceof ItemArmor);
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        try {
            if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75211_c() == RandomUtils.getWirelessTerm(player.field_71071_by)) {
                return null;
            }
            return super.func_75144_a(slot, button, flag, player);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!backwards && k < end || backwards && k >= start)) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (!slot.func_75214_a(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.field_77994_a + stack.field_77994_a;
                    if (l <= stack.func_77976_d() && l <= slot.func_75219_a()) {
                        stack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        this.boosterInventory.func_70296_d();
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < stack.func_77976_d() && l < slot.func_75219_a()) {
                        stack.field_77994_a -= stack.func_77976_d() - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = stack.func_77976_d();
                        this.boosterInventory.func_70296_d();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (!slot.func_75214_a(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.field_77994_a;
                    if (l <= slot.func_75219_a()) {
                        slot.func_75215_d(stack.func_77946_l());
                        stack.field_77994_a = 0;
                        this.boosterInventory.func_70296_d();
                        flag1 = true;
                        break;
                    }
                    this.func_75141_a(k, new ItemStack(stack.func_77973_b(), slot.func_75219_a(), stack.func_77960_j()));
                    stack.field_77994_a -= slot.func_75219_a();
                    this.boosterInventory.func_70296_d();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }
}

