/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.proxy;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.storage.data.IAEItemStack;
import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTPlayerSource;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketConfigSync;
import net.p455w0rd.wirelesscraftingterminal.handlers.AchievementHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.ConfigHandler;
import net.p455w0rd.wirelesscraftingterminal.items.ItemEnum;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class CommonProxy {
    Achievement wctAch = AchievementHandler.wctAch;
    Achievement boosterAch = AchievementHandler.boosterAch;
    Achievement magnetAch = AchievementHandler.magnetAch;

    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
    }

    public void registerItems() {
        for (ItemEnum item : ItemEnum.VALUES) {
            GameRegistry.registerItem((Item)item.getItem(), (String)item.getInternalName());
        }
    }

    public void removeItemsFromNEI() {
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent e) {
        ItemStack magnetItem;
        NBTTagCompound magCompound;
        NBTTagCompound nbtTC;
        NBTTagList tagList;
        ItemStack wirelessTerm = null;
        EntityPlayer player = e.player;
        InventoryPlayer playerInv = player instanceof EntityPlayerMP ? player.field_71071_by.field_70458_d.field_71071_by : player.field_71071_by;
        IInventory handler = BaublesApi.getBaubles((EntityPlayer)player);
        if (handler != null) {
            for (int i = 0; i < handler.func_70302_i_(); ++i) {
                ItemStack item = handler.func_70301_a(i);
                if (item == null || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
                wirelessTerm = item;
                break;
            }
        }
        if (wirelessTerm == null) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = playerInv.func_70301_a(i);
                if (item == null || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
                wirelessTerm = item;
                break;
            }
        }
        if (wirelessTerm == null) {
            return;
        }
        if (wirelessTerm.func_77942_o() && (tagList = (nbtTC = wirelessTerm.func_77978_p()).func_150295_c("MagnetSlot", 10)) != null && (magCompound = tagList.func_150305_b(0)) != null && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)magCompound)) != null) {
            ((ItemMagnet)magnetItem.func_77973_b()).setItemStack(magnetItem);
            if (magnetItem.func_77973_b() instanceof ItemMagnet) {
                ((ItemMagnet)magnetItem.func_77973_b()).doMagnet(magnetItem, e.player.field_70170_p, e.player, wirelessTerm);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ConfigHandler.removeBooster();
            ConfigHandler.removeBoosterIcon();
            if (ConfigHandler.firstLoad) {
                ConfigHandler.firstLoad = false;
            } else {
                ConfigHandler.reloadRecipes();
            }
        } else {
            PacketConfigSync p = new PacketConfigSync(Reference.WCT_MAX_POWER, Reference.WCT_EASYMODE_ENABLED, Reference.WCT_BOOSTER_ENABLED, Reference.WCT_BOOSTER_DROPCHANCE, Reference.WCT_MINETWEAKER_OVERRIDE);
            NetworkHandler.instance.sendTo(p, (EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (!Reference.WCT_EASYMODE_ENABLED && Reference.WCT_BOOSTER_ENABLED && Reference.WCT_BOOSTERDROP_ENABLED) {
            Random rand;
            int n;
            ItemStack stack = new ItemStack(ItemEnum.BOOSTER_CARD.getItem());
            EntityItem drop = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, stack);
            if (event.entity instanceof EntityDragon) {
                event.drops.add(drop);
            }
            if (event.entity instanceof EntityWither && (n = (rand = new Random()).nextInt()) <= Reference.WCT_BOOSTER_DROPCHANCE) {
                event.drops.add(drop);
            }
        }
    }

    @SubscribeEvent
    public void pickupEvent(EntityItemPickupEvent e) {
        try {
            EntityPlayer player = e.entityPlayer;
            if (player == null) {
                return;
            }
            EntityItem itemEntity = e.item;
            ItemStack stack = itemEntity.func_92059_d();
            InventoryPlayer playerInv = player.field_71071_by;
            World world = player.func_130014_f_();
            if (playerInv == null || playerInv.field_70458_d == null || world.field_72995_K) {
                return;
            }
            if (Reference.WCT_BOOSTER_ENABLED && !Reference.WCT_EASYMODE_ENABLED && stack.func_77973_b() == ItemEnum.BOOSTER_CARD.getItem()) {
                AchievementHandler.triggerAch(this.boosterAch, player);
            }
            if (RandomUtils.getWirelessTerm(playerInv) != null) {
                ItemStack magnetStack;
                ItemStack WCTStack = RandomUtils.getWirelessTerm(playerInv);
                if (RandomUtils.isMagnetInstalled(playerInv) && (magnetStack = RandomUtils.getMagnet(playerInv)).func_77973_b() instanceof ItemMagnet) {
                    ItemMagnet magnet = (ItemMagnet)magnetStack.func_77973_b();
                    magnet.obj = ContainerWirelessCraftingTerminal.getGuiObject(WCTStack, player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    magnet.civ = magnet.obj;
                    magnet.powerSrc = magnet.civ;
                    magnet.monitor = magnet.civ.getItemInventory();
                    magnet.cellInv = magnet.monitor;
                    magnet.mySrc = new WCTPlayerSource(player, magnet.obj);
                    boolean ignoreRange = magnet.isBoosterInstalled(WCTStack) && Reference.WCT_BOOSTER_ENABLED;
                    boolean hasAxxess = magnet.hasNetworkAccess(SecurityPermissions.INJECT, true, player, WCTStack);
                    if (ignoreRange && hasAxxess || magnet.obj.rangeCheck(false) && hasAxxess) {
                        if (magnet.isActivated(magnetStack)) {
                            List<ItemStack> filteredList = magnet.getFilteredItems(magnetStack);
                            IAEItemStack ais = AEApi.instance().storage().createItemStack(stack);
                            if (magnet.getMode(magnetStack)) {
                                if (filteredList != null && magnet.isItemFiltered(stack, filteredList) && filteredList.size() > 0) {
                                    if (magnet.doInject(ais, stack.field_77994_a, player, itemEntity, stack, world)) {
                                        stack = null;
                                        itemEntity.func_70106_y();
                                        e.setCanceled(true);
                                    }
                                } else if (magnetStack.func_77960_j() == 1) {
                                    if (player.field_71071_by.func_70441_a(stack)) {
                                        player.func_71001_a((Entity)itemEntity, stack.field_77994_a);
                                        world.func_72956_a((Entity)player, "random.pop", 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                                    }
                                } else {
                                    magnet.doVanillaPickup(itemEntity, player, stack, world, stack.field_77994_a);
                                }
                            } else if (!magnet.isItemFiltered(stack, filteredList) || filteredList == null || filteredList.size() <= 0) {
                                if (magnet.doInject(ais, stack.field_77994_a, player, itemEntity, stack, world)) {
                                    stack = null;
                                    itemEntity.func_70106_y();
                                    e.setCanceled(true);
                                } else {
                                    player.field_71071_by.func_70441_a(stack);
                                }
                            } else if (magnetStack.func_77960_j() == 1) {
                                if (player.field_71071_by.func_70441_a(stack)) {
                                    player.func_71001_a((Entity)itemEntity, stack.field_77994_a);
                                    world.func_72956_a((Entity)player, "random.pop", 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                                }
                            } else {
                                magnet.doVanillaPickup(itemEntity, player, stack, world, stack.field_77994_a);
                            }
                        }
                    } else {
                        magnet.doVanillaPickup(itemEntity, player, stack, world, stack.field_77994_a);
                    }
                }
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.field_70128_L || event.player instanceof FakePlayer || event.crafting == null) {
            return;
        }
        if (event.crafting.func_77973_b() == ItemEnum.WIRELESS_CRAFTING_TERMINAL.getItem()) {
            AchievementHandler.triggerAch(this.wctAch, event.player);
        }
        if (event.crafting.func_77973_b() == ItemEnum.MAGNET_CARD.getItem()) {
            AchievementHandler.triggerAch(this.magnetAch, event.player);
        }
        if (Reference.WCT_BOOSTER_ENABLED && Reference.WCT_EASYMODE_ENABLED && event.crafting.func_77973_b() == ItemEnum.BOOSTER_CARD.getItem()) {
            AchievementHandler.triggerAch(this.boosterAch, event.player);
        }
    }
}

