/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import com.glodblock.github.client.gui.container.base.FCContainerFluidConfigurable;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidStorageBus;
import com.glodblock.github.inventory.slot.OptionalFluidSlotFakeTypeOnly;
import com.glodblock.github.util.Ae2Reflect;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerFluidStorageBus
extends FCContainerFluidConfigurable {
    public final PartFluidStorageBus bus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;

    public ContainerFluidStorageBus(InventoryPlayer ip, PartFluidStorageBus te) {
        super(ip, (IUpgradeableHost)te);
        this.bus = te;
    }

    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int xo = 8;
        int yo = 29;
        IInventory upgrades = Ae2Reflect.getUpgradeList(this).getInventoryByName("upgrades");
        IInventory config = Ae2Reflect.getUpgradeList(this).getInventoryByName("config");
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new OptionalFluidSlotFakeTypeOnly(config, null, (IOptionalSlotHost)this, y * 9 + x, 8, 29, x, y, y));
            }
        }
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        if (this.supportCapacity()) {
            int y = slot / 9;
            int upgrades = Ae2Reflect.getUpgradeList(this).getInstalledUpgrades(Upgrades.CAPACITY);
            return y < upgrades + 2;
        }
        return true;
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 5;
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setReadWriteMode((AccessRestriction)Ae2Reflect.getUpgradeList(this).getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)Ae2Reflect.getUpgradeList(this).getConfigManager().getSetting(Settings.STORAGE_FILTER));
        }
        this.standardDetectAndSendChanges();
    }

    public boolean isSlotEnabled(int idx) {
        if (Ae2Reflect.getUpgradeList(this).getInstalledUpgrades(Upgrades.ORE_FILTER) > 0) {
            return false;
        }
        int upgrades = Ae2Reflect.getUpgradeList(this).getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx - 2;
    }

    public void clear() {
        AppEngInternalAEInventory h = this.bus.getConfig();
        for (int i = 0; i < h.func_70302_i_(); ++i) {
            h.func_70299_a(i, null);
        }
        this.func_75142_b();
    }

    public void partition() {
        AppEngInternalAEInventory h = this.bus.getConfig();
        MEInventoryHandler<IAEFluidStack> cellInv = this.bus.getInternalHandler();
        Object i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(AEApi.instance().storage().createFluidList(), IterationCounter.fetchNewId());
            i = list.iterator();
        }
        for (int x = 0; x < h.func_70302_i_(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                h.func_70299_a(x, ItemFluidPacket.newStack((IAEFluidStack)i.next()));
                continue;
            }
            h.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    @Override
    public AppEngInternalAEInventory getFakeFluidInv() {
        return (AppEngInternalAEInventory)this.bus.getInventoryByName("config");
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }
}

