/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod.hooker;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.IGuiTooltipHandler;
import appeng.crafting.MECraftingInventory;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.InventoryAdaptor;
import com.glodblock.github.client.gui.GuiFluidCraftConfirm;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.CraftingGridCacheFluidInventoryProxyCell;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import com.glodblock.github.inventory.FluidConvertingInventoryCrafting;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.Ae2Reflect;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class CoreModHooks {
    public static InventoryCrafting wrapCraftingBuffer(InventoryCrafting inv) {
        return new FluidConvertingInventoryCrafting(inv.field_70465_c, inv.field_70464_b, inv.func_70302_i_() / inv.field_70464_b);
    }

    public static IAEItemStack wrapFluidPacketStack(IAEItemStack stack) {
        IAEItemStack dropStack;
        if (stack.getItem() == ItemAndBlockHolder.PACKET && (dropStack = ItemFluidDrop.newAeStack(ItemFluidPacket.getFluidStack(stack.getItemStack()))) != null) {
            return dropStack;
        }
        return stack;
    }

    public static ItemStack removeFluidPackets(InventoryCrafting inv, int index) {
        ItemStack stack = inv.func_70301_a(index);
        if (stack != null && stack.func_77973_b() instanceof ItemFluidPacket) {
            FluidStack fluid = ItemFluidPacket.getFluidStack(stack);
            return ItemFluidDrop.newStack(fluid);
        }
        return stack;
    }

    @Nullable
    public static InventoryAdaptor wrapInventory(@Nullable TileEntity tile, ForgeDirection face) {
        return tile != null ? FluidConvertingInventoryAdaptor.wrap(tile, face) : null;
    }

    public static long getCraftingByteCost(IAEItemStack stack) {
        return stack.getItem() instanceof ItemFluidDrop ? (long)Math.ceil((double)stack.getStackSize() / 1000.0) : stack.getStackSize();
    }

    public static long getFluidDropsByteCost(long totalBytes, long originByte, IAEItemStack stack) {
        if (stack != null && stack.getItem() instanceof ItemFluidDrop) {
            return (long)Math.ceil((double)originByte / 1000.0) + totalBytes;
        }
        return originByte + totalBytes;
    }

    public static ItemStack displayFluid(IAEItemStack aeStack) {
        if (aeStack.getItemStack() != null && aeStack.getItemStack().func_77973_b() instanceof ItemFluidDrop) {
            FluidStack fluid = ItemFluidDrop.getFluidStack(aeStack.getItemStack());
            return ItemFluidPacket.newDisplayStack(fluid);
        }
        return aeStack.getItemStack();
    }

    public static long getFluidSize(IAEItemStack aeStack) {
        if (aeStack.getItemStack() != null && aeStack.getItemStack().func_77973_b() instanceof ItemFluidDrop) {
            return (long)Math.max((double)aeStack.getStackSize() / 1000.0, 1.0);
        }
        return aeStack.getStackSize();
    }

    public static List<IMEInventoryHandler> craftingGridCacheGetCellArray(CraftingGridCache instance, StorageChannel channel) {
        return channel == StorageChannel.ITEMS ? Arrays.asList(instance) : Arrays.asList(new CraftingGridCacheFluidInventoryProxyCell(instance));
    }

    public static void storeFluidItem(CraftingCPUCluster instance) {
        IGrid g = Ae2Reflect.getGrid(instance);
        if (g == null) {
            return;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor ii = sg.getItemInventory();
        IMEMonitor jj = sg.getFluidInventory();
        MECraftingInventory inventory = Ae2Reflect.getCPUInventory(instance);
        for (IAEItemStack is : inventory.getItemList()) {
            if ((is = inventory.extractItems(is.copy(), Actionable.MODULATE, (BaseActionSource)Ae2Reflect.getCPUSource(instance))) != null) {
                Ae2Reflect.postCPUChange(instance, is, Ae2Reflect.getCPUSource(instance));
                if (is.getItem() instanceof ItemFluidDrop) {
                    IAEFluidStack fluidDrop = ItemFluidDrop.getAeFluidStack(is);
                    if ((fluidDrop = (IAEFluidStack)jj.injectItems((IAEStack)fluidDrop, Actionable.MODULATE, (BaseActionSource)Ae2Reflect.getCPUSource(instance))) == null) {
                        is = null;
                    } else {
                        is.setStackSize(fluidDrop.getStackSize());
                    }
                } else {
                    is = (IAEItemStack)ii.injectItems((IAEStack)is, Actionable.MODULATE, (BaseActionSource)Ae2Reflect.getCPUSource(instance));
                }
            }
            if (is == null) continue;
            inventory.injectItems(is, Actionable.MODULATE, (BaseActionSource)Ae2Reflect.getCPUSource(instance));
        }
        if (inventory.getItemList().isEmpty()) {
            Ae2Reflect.setCPUInventory(instance, new MECraftingInventory());
        }
        Ae2Reflect.markCPUDirty(instance);
    }

    public static ItemStack getStackUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (gui instanceof IGuiTooltipHandler) {
            IGuiTooltipHandler guiTooltipHandler = (IGuiTooltipHandler)gui;
            return guiTooltipHandler.getHoveredStack();
        }
        return null;
    }

    public static boolean shouldShowTooltip(GuiContainer gui) {
        if (gui instanceof GuiFluidCraftConfirm) {
            GuiFluidCraftConfirm guiCraftConfirm = (GuiFluidCraftConfirm)gui;
            return guiCraftConfirm.getHoveredStack() == null;
        }
        return true;
    }
}

