/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.gtnhlib.client.renderer.stacks.IStateStack;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.TextureBindingStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Feature {
    private static final int[] supportedAttribs = new int[]{512, 16384, 1, 256, 8192, 65536, 128, 32768, 64, 4, 131072, 0x20000000, 32, 2, 8, 16, 524288, 1024, 262144, 4096, 2048};
    static final Int2ObjectMap<Set<IStateStack<?>>> maskToFeaturesMap = new Int2ObjectOpenHashMap();
    private static final Map<Integer, Set<IStateStack<?>>> attribToFeatures = new HashMap();

    static Set<IStateStack<?>> maskToFeatures(int mask) {
        if (maskToFeaturesMap.containsKey(mask)) {
            return (Set)maskToFeaturesMap.get(mask);
        }
        HashSet features = new HashSet();
        for (int attrib : supportedAttribs) {
            if ((mask & attrib) != attrib) continue;
            features.addAll(Feature.getFeatures(attrib));
        }
        maskToFeaturesMap.put(mask, features);
        return features;
    }

    public static Set<IStateStack<?>> getFeatures(int attrib) {
        return attribToFeatures.getOrDefault(attrib, Collections.emptySet());
    }

    static {
        attribToFeatures.put(16384, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.alphaTest, (Object)GLStateManager.alphaState, (Object)GLStateManager.blendMode, (Object)GLStateManager.blendState, (Object)GLStateManager.colorMask, (Object)GLStateManager.clearColor, (Object[])new IStateStack[0]));
        attribToFeatures.put(1, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.color));
        attribToFeatures.put(256, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.depthTest, (Object)GLStateManager.depthState));
        HashSet<BooleanStateStack> enableBits = new HashSet<BooleanStateStack>((Collection<BooleanStateStack>)ImmutableSet.of((Object)GLStateManager.alphaTest, (Object)GLStateManager.blendMode, (Object)GLStateManager.colorMaterial, (Object)GLStateManager.cullState, (Object)GLStateManager.depthTest, (Object)GLStateManager.fogMode, (Object[])new BooleanStateStack[]{GLStateManager.lightStates[0], GLStateManager.lightStates[1], GLStateManager.lightStates[2], GLStateManager.lightStates[3], GLStateManager.lightStates[4], GLStateManager.lightStates[5], GLStateManager.lightStates[6], GLStateManager.lightStates[7], GLStateManager.lightingState, GLStateManager.scissorTest}));
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            enableBits.add(GLStateManager.textures.getTextureUnitStates(i));
        }
        attribToFeatures.put(8192, enableBits);
        attribToFeatures.put(65536, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(128, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.fogMode, (Object)GLStateManager.fogState));
        attribToFeatures.put(32768, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(64, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.colorMaterial, (Object)GLStateManager.colorMaterialFace, (Object)GLStateManager.colorMaterialParameter, (Object)GLStateManager.lightModel, (Object)GLStateManager.lightingState, (Object)GLStateManager.lightStates[0], (Object[])new IStateStack[]{GLStateManager.lightStates[1], GLStateManager.lightStates[2], GLStateManager.lightStates[3], GLStateManager.lightStates[4], GLStateManager.lightStates[5], GLStateManager.lightStates[6], GLStateManager.lightStates[7], GLStateManager.lightDataStates[0], GLStateManager.lightDataStates[1], GLStateManager.lightDataStates[2], GLStateManager.lightDataStates[3], GLStateManager.lightDataStates[4], GLStateManager.lightDataStates[5], GLStateManager.lightDataStates[6], GLStateManager.lightDataStates[7], GLStateManager.frontMaterial, GLStateManager.backMaterial, GLStateManager.shadeModelState}));
        attribToFeatures.put(4, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(131072, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(0x20000000, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(32, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(2, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(8, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.cullState));
        attribToFeatures.put(16, (Set<IStateStack<?>>)ImmutableSet.of());
        attribToFeatures.put(524288, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.scissorTest));
        attribToFeatures.put(1024, (Set<IStateStack<?>>)ImmutableSet.of());
        HashSet<TextureBindingStack> textureAttribs = new HashSet<TextureBindingStack>((Collection<TextureBindingStack>)ImmutableSet.of((Object)GLStateManager.activeTextureUnit));
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            textureAttribs.add(GLStateManager.textures.getTextureUnitBindings(i));
        }
        attribToFeatures.put(262144, textureAttribs);
        attribToFeatures.put(4096, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.matrixMode, (Object)GLStateManager.rescaleNormalState));
        attribToFeatures.put(2048, (Set<IStateStack<?>>)ImmutableSet.of((Object)GLStateManager.viewportState));
    }
}

