/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.states.ISettableState;
import java.nio.FloatBuffer;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FogState
implements ISettableState<FogState> {
    protected int fogMode = 2048;
    protected final Vector3d fogColor = new Vector3d(0.0, 0.0, 0.0);
    protected float fogAlpha = 1.0f;
    protected final FloatBuffer fogColorBuffer = FloatBuffer.allocate(4);
    protected float density = 1.0f;
    protected float start;
    protected float end = 1.0f;

    @Override
    public FogState set(FogState state) {
        this.fogMode = state.fogMode;
        this.fogColor.set((Vector3dc)state.fogColor);
        this.fogAlpha = state.fogAlpha;
        this.fogColorBuffer.put(0, state.fogColorBuffer.get(0));
        this.density = state.density;
        this.start = state.start;
        this.end = state.end;
        return this;
    }

    @Override
    public boolean sameAs(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof FogState)) {
            return false;
        }
        FogState fogState = (FogState)state;
        return this.fogMode == fogState.fogMode && Float.compare(fogState.fogAlpha, this.fogAlpha) == 0 && Float.compare(fogState.density, this.density) == 0 && Float.compare(fogState.start, this.start) == 0 && Float.compare(fogState.end, this.end) == 0 && this.fogColor.equals((Object)fogState.fogColor);
    }

    @Override
    public FogState copy() {
        return new FogState().set(this);
    }

    public int getFogMode() {
        return this.fogMode;
    }

    public Vector3d getFogColor() {
        return this.fogColor;
    }

    public float getFogAlpha() {
        return this.fogAlpha;
    }

    public FloatBuffer getFogColorBuffer() {
        return this.fogColorBuffer;
    }

    public float getDensity() {
        return this.density;
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    public void setFogMode(int fogMode) {
        this.fogMode = fogMode;
    }

    public void setFogAlpha(float fogAlpha) {
        this.fogAlpha = fogAlpha;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public void setStart(float start) {
        this.start = start;
    }

    public void setEnd(float end) {
        this.end = end;
    }
}

