/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.transform.BlockTransformer;
import com.gtnewhorizons.angelica.transform.RedirectorTransformer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.mixin.transformer.Config;

public class MixinCompatHackTweaker
implements ITweaker {
    public static final boolean DISABLE_OPTIFINE_FASTCRAFT_BETTERFPS = true;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.verifyDependencies();
        AngelicaTweaker.LOGGER.info("Disabling Optifine, Fastcraft, BetterFPS, and other incompatible mods (if present)");
        this.disableIncompatibleMods();
        if (AngelicaConfig.enableHudCaching) {
            this.disableXaerosMinimapWaypointTransformer();
        }
    }

    private void verifyDependencies() {
        if (MixinCompatHackTweaker.class.getResource("/it/unimi/dsi/fastutil/ints/Int2ObjectMap.class") == null) {
            throw new RuntimeException("Missing dependency: Angelica requires GTNHLib 0.2.1 or newer! Download: https://modrinth.com/mod/gtnhlib");
        }
    }

    private void disableXaerosMinimapWaypointTransformer() {
        try {
            LaunchClassLoader lcl = Launch.classLoader;
            Field xformersField = lcl.getClass().getDeclaredField("transformers");
            xformersField.setAccessible(true);
            List xformers = (List)xformersField.get(lcl);
            for (int idx = xformers.size() - 1; idx >= 0; --idx) {
                String name = ((IClassTransformer)xformers.get(idx)).getClass().getName();
                if (!name.startsWith("xaero.common.core.transformer.GuiIngameForgeTransformer")) continue;
                AngelicaTweaker.LOGGER.info("Removing transformer " + name);
                xformers.remove(idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void disableIncompatibleMods() {
        try {
            LaunchClassLoader lcl = Launch.classLoader;
            Field xformersField = lcl.getClass().getDeclaredField("transformers");
            xformersField.setAccessible(true);
            List xformers = (List)xformersField.get(lcl);
            for (int idx = xformers.size() - 1; idx >= 0; --idx) {
                String name = ((IClassTransformer)xformers.get(idx)).getClass().getName();
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft") && !name.startsWith("me.guichaguri.betterfps")) continue;
                AngelicaTweaker.LOGGER.info("Removing transformer " + name);
                xformers.remove(idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Field injectedContainersField = Loader.class.getDeclaredField("injectedContainers");
            injectedContainersField.setAccessible(true);
            List containers = (List)injectedContainersField.get(Loader.class);
            for (int idx = containers.size() - 1; idx >= 0; --idx) {
                String name = (String)containers.get(idx);
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft")) continue;
                AngelicaTweaker.LOGGER.info("Removing mod container " + name);
                containers.remove(idx);
            }
            Field reparsedCoremodsField = CoreModManager.class.getDeclaredField("reparsedCoremods");
            Field loadedCoremodsField = CoreModManager.class.getDeclaredField("loadedCoremods");
            reparsedCoremodsField.setAccessible(true);
            loadedCoremodsField.setAccessible(true);
            ArrayList reparsedCoremods = (ArrayList)reparsedCoremodsField.get(CoreModManager.class);
            ArrayList loadedCoremods = (ArrayList)loadedCoremodsField.get(CoreModManager.class);
            for (int idx = reparsedCoremods.size() - 1; idx >= 0; --idx) {
                String coreMod = (String)reparsedCoremods.get(idx);
                if (!coreMod.startsWith("optimizationsandtweaks")) continue;
                AngelicaTweaker.LOGGER.info("Removing reparsed coremod " + coreMod);
                loadedCoremods.add((String)reparsedCoremods.remove(idx));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            MixinPlatformManager platformManager;
            ArrayList mixinConfigsDefault = (ArrayList)Launch.blackboard.get("mixin.configs.default");
            if (mixinConfigsDefault != null) {
                for (int idx = mixinConfigsDefault.size() - 1; idx >= 0; --idx) {
                    String name = (String)mixinConfigsDefault.get(idx);
                    if (name == null || !name.contains("optimizationsandtweaks")) continue;
                    AngelicaTweaker.LOGGER.info("Removing mixin config " + name);
                    mixinConfigsDefault.remove(idx);
                }
            }
            Set mixinConfigs = (Set)Launch.blackboard.get("mixin.configs.queue");
            HashSet<Config> toRemove = new HashSet<Config>();
            if (mixinConfigs != null) {
                for (Config config : mixinConfigs) {
                    String name = config.getName();
                    if (name == null || !name.contains("optimizationsandtweaks")) continue;
                    AngelicaTweaker.LOGGER.info("Removing queued mixin config " + config.getName());
                    toRemove.add(config);
                }
                mixinConfigs.removeAll(toRemove);
            }
            if ((platformManager = (MixinPlatformManager)Launch.blackboard.get("mixin.platform")) != null) {
                Field containersField = platformManager.getClass().getDeclaredField("containers");
                containersField.setAccessible(true);
                Map containers = (Map)containersField.get(platformManager);
                for (Map.Entry entry : containers.entrySet()) {
                    String attribute = ((IContainerHandle)entry.getKey()).getAttribute("MixinConfigs");
                    if (attribute == null || !attribute.contains("optimizationsandtweaks")) continue;
                    AngelicaTweaker.LOGGER.info("Removing mixin container " + ((IContainerHandle)entry.getKey()).toString());
                    containers.remove(entry.getKey());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        if (FMLLaunchHandler.side().isClient()) {
            boolean rfbLoaded;
            boolean bl = rfbLoaded = Launch.blackboard.getOrDefault("angelica.rfbPluginLoaded", Boolean.FALSE) == Boolean.TRUE;
            if (!rfbLoaded) {
                Launch.classLoader.registerTransformer(RedirectorTransformer.class.getName());
            }
            if (AngelicaConfig.enableSodium) {
                Launch.classLoader.registerTransformer(BlockTransformer.class.getName());
            }
        }
        return new String[0];
    }
}

