/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.attribute;

import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.attribute.BufferVertexFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttribute;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;

public class GlVertexFormat<T extends Enum<T>>
implements BufferVertexFormat {
    private static final GlVertexAttribute EMPTY = new GlVertexAttribute(GlVertexAttributeFormat.FLOAT, 0, false, 0, 0);
    private final Class<T> attributeEnum;
    private final EnumMap<T, GlVertexAttribute> attributesKeyed;
    private final GlVertexAttribute[] attributesArray;
    private final int stride;

    public GlVertexFormat(Class<T> attributeEnum, EnumMap<T, GlVertexAttribute> attributesKeyed, int stride) {
        this.attributeEnum = attributeEnum;
        this.attributesKeyed = attributesKeyed;
        this.attributesArray = attributesKeyed.values().toArray(new GlVertexAttribute[0]);
        this.stride = stride;
    }

    public static <T extends Enum<T>> Builder<T> builder(Class<T> type, int stride) {
        return new Builder<T>(type, stride);
    }

    public GlVertexAttribute getAttribute(T name) {
        GlVertexAttribute attr = this.attributesKeyed.get(name);
        if (attr == null) {
            throw new NullPointerException("No attribute exists for " + ((Enum)name).toString());
        }
        return attr;
    }

    public String toString() {
        return String.format("GlVertexFormat<%s>{attributes=%d,stride=%d}", this.attributeEnum.getName(), this.attributesKeyed.size(), this.stride);
    }

    public GlVertexAttribute[] getAttributesArray() {
        return this.attributesArray;
    }

    @Override
    public int getStride() {
        return this.stride;
    }

    public static class Builder<T extends Enum<T>> {
        private final EnumMap<T, GlVertexAttribute> attributes;
        private final Class<T> type;
        private final int stride;

        public Builder(Class<T> type, int stride) {
            this.type = type;
            this.attributes = new EnumMap(type);
            this.stride = stride;
        }

        public Builder<T> addElement(T type, int pointer, GlVertexAttributeFormat format, int count, boolean normalized) {
            return this.addElement(type, new GlVertexAttribute(format, count, normalized, pointer, this.stride));
        }

        private Builder<T> addElement(T type, GlVertexAttribute attribute) {
            if (attribute.getPointer() >= this.stride) {
                throw new IllegalArgumentException("Element starts outside vertex format");
            }
            if (attribute.getPointer() + attribute.getSize() > this.stride) {
                throw new IllegalArgumentException("Element extends outside vertex format");
            }
            if (this.attributes.put(type, attribute) != null) {
                throw new IllegalStateException("Generic attribute " + ((Enum)type).name() + " already defined in vertex format");
            }
            return this;
        }

        public GlVertexFormat<T> build() {
            int size = 0;
            for (Enum key : (Enum[])this.type.getEnumConstants()) {
                GlVertexAttribute attribute = this.attributes.get(key);
                if (attribute == null) {
                    if (key == ChunkMeshAttribute.NORMAL || key == ChunkMeshAttribute.TANGENT || key == ChunkMeshAttribute.MID_TEX_COORD || key == ChunkMeshAttribute.BLOCK_ID || key == ChunkMeshAttribute.MID_BLOCK) {
                        attribute = EMPTY;
                    } else {
                        throw new NullPointerException("Generic attribute not assigned to enumeration " + key.name());
                    }
                }
                size = Math.max(size, attribute.getPointer() + attribute.getSize());
            }
            if (this.stride < size) {
                throw new IllegalArgumentException("Stride is too small");
            }
            return new GlVertexFormat<T>(this.type, this.attributes, this.stride);
        }
    }
}

