/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.shaderselection.ShaderPackEntry;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.element.widget.IrisButton;
import net.coderbot.iris.gui.element.widget.IrisImageButton;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;

public class ShaderPackScreen
extends GuiScreen
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final String SELECT_TITLE = I18n.func_135052_a((String)"pack.iris.select.title", (Object[])new Object[0]);
    private static final String CONFIGURE_TITLE = I18n.func_135052_a((String)"pack.iris.configure.title", (Object[])new Object[0]);
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final GuiScreen parent;
    private final String title;
    private final String irisTextComponent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private GuiButton screenSwitchButton;
    private String notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<String> hoveredElementCommentTitle = Optional.empty();
    private List<String> hoveredElementCommentBody = new ArrayList<String>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;
    private static final String development = "Development Environment";
    private String developmentComponent;
    private String updateComponent;
    private boolean guiHidden = false;
    private boolean dirty = false;
    private float guiButtonHoverTimer = 0.0f;

    public ShaderPackScreen(GuiScreen parent) {
        this.title = I18n.func_135052_a((String)"options.iris.shaderPackSelection.title", (Object[])new Object[0]);
        this.parent = parent;
        String irisName = "AngelicaShaders";
        if (Iris.INSTANCE.isDevelopmentEnvironment) {
            this.developmentComponent = development;
            irisName = irisName.replace("-development-environment", "");
        }
        this.irisTextComponent = irisName;
        this.refreshForChangedPack();
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        if (this.dirty) {
            this.dirty = false;
            this.func_73866_w_();
        }
        if (this.field_146297_k.field_71441_e == null) {
            super.func_146276_q_();
        } else if (!this.guiHidden) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 1327702819, 1327702819);
        }
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.shaderOptionList.func_148128_a(mouseX, mouseY, delta);
            } else {
                this.shaderPackList.func_148128_a(mouseX, mouseY, delta);
            }
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
        float previousHoverTimer = this.guiButtonHoverTimer;
        super.func_73863_a(mouseX, mouseY, delta);
        if (previousHoverTimer == this.guiButtonHoverTimer) {
            this.guiButtonHoverTimer = 0.0f;
        }
        if (!this.guiHidden) {
            this.func_73732_a(this.field_146289_q, this.title, (int)((double)this.field_146294_l * 0.5), 8, 0xFFFFFF);
            if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
                this.func_73732_a(this.field_146289_q, this.notificationDialog, (int)((double)this.field_146294_l * 0.5), 21, 0xFFFFFF);
            } else if (this.optionMenuOpen) {
                this.func_73732_a(this.field_146289_q, CONFIGURE_TITLE, (int)((double)this.field_146294_l * 0.5), 21, 0xFFFFFF);
            } else {
                this.func_73732_a(this.field_146289_q, SELECT_TITLE, (int)((double)this.field_146294_l * 0.5), 21, 0xFFFFFF);
            }
            if (this.isDisplayingComment()) {
                int y;
                int panelHeight = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
                int x = mouseX + 5;
                if (x + 314 >= this.field_146294_l - 4) {
                    x = this.field_146294_l - 318;
                }
                if ((y = mouseY + 8) + panelHeight >= this.field_146295_m - 4) {
                    y = this.field_146295_m - (panelHeight + 4);
                }
                GuiUtil.drawPanel(x, y, 314, panelHeight);
                this.field_146289_q.func_78261_a(this.hoveredElementCommentTitle.orElse(""), x + 4, y + 4, 0xFFFFFF);
                for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                    this.field_146289_q.func_78261_a(this.hoveredElementCommentBody.get(i), x + 4, y + 16 + i * 10, 0xFFFFFF);
                }
            }
        }
        for (Runnable render : TOP_LAYER_RENDER_QUEUE) {
            render.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
        if (this.developmentComponent != null) {
            this.field_146289_q.func_78261_a(this.developmentComponent, 2, this.field_146295_m - 10, 0xFFFFFF);
            this.field_146289_q.func_78261_a(this.irisTextComponent, 2, this.field_146295_m - 20, 0xFFFFFF);
        } else if (this.updateComponent != null) {
            this.field_146289_q.func_78261_a(this.updateComponent, 2, this.field_146295_m - 10, 0xFFFFFF);
            this.field_146289_q.func_78261_a(this.irisTextComponent, 2, this.field_146295_m - 20, 0xFFFFFF);
        } else {
            this.field_146289_q.func_78261_a(this.irisTextComponent, 2, this.field_146295_m - 10, 0xFFFFFF);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int bottomCenter = this.field_146294_l / 2 - 50;
        int topCenter = this.field_146294_l / 2 - 76;
        boolean inWorld = this.field_146297_k.field_71441_e != null;
        this.shaderPackList = new ShaderPackSelectionList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 58, 0, this.field_146294_l);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, currentPack, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 58, 0, this.field_146294_l);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (inWorld) {
            this.shaderPackList.setRenderBackground(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.setRenderBackground(false);
            }
        }
        this.field_146292_n.clear();
        if (!this.guiHidden) {
            this.field_146292_n.add(new IrisButton(bottomCenter + 104, this.field_146295_m - 27, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> this.onClose()));
            this.field_146292_n.add(new IrisButton(bottomCenter, this.field_146295_m - 27, 100, 20, I18n.func_135052_a((String)"options.iris.apply", (Object[])new Object[0]), button -> this.applyChanges()));
            this.field_146292_n.add(new IrisButton(bottomCenter - 104, this.field_146295_m - 27, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.dropChangesAndClose()));
            this.field_146292_n.add(new IrisButton(topCenter - 78, this.field_146295_m - 51, 152, 20, I18n.func_135052_a((String)"options.iris.openShaderPackFolder", (Object[])new Object[0]), button -> this.openShaderPackFolder()));
            this.screenSwitchButton = new IrisButton(topCenter + 78, this.field_146295_m - 51, 152, 20, I18n.func_135052_a((String)"options.iris.shaderPackList", (Object[])new Object[0]), button -> {
                this.optionMenuOpen = !this.optionMenuOpen;
                this.applyChanges();
                this.func_73866_w_();
            });
            this.field_146292_n.add(this.screenSwitchButton);
            this.refreshScreenSwitchButton();
        }
        if (inWorld) {
            String showOrHide = this.guiHidden ? I18n.func_135052_a((String)"options.iris.gui.show", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.iris.gui.hide", (Object[])new Object[0]);
            float endOfLastButton = (float)this.field_146294_l / 2.0f + 154.0f;
            float freeSpace = (float)this.field_146294_l - endOfLastButton;
            int x = freeSpace > 100.0f ? this.field_146294_l - 50 : (freeSpace < 20.0f ? this.field_146294_l - 20 : (int)(endOfLastButton + freeSpace / 2.0f) - 10);
            this.field_146292_n.add(new IrisImageButton(x, this.field_146295_m - 39, 20, 20, this.guiHidden ? 20 : 0, 146, 20, GuiUtil.IRIS_WIDGETS_TEX, button -> {
                this.guiHidden = !this.guiHidden;
                this.dirty = true;
            }));
        }
        this.hoveredElement = null;
        this.hoveredElementCommentTimer = 0;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        boolean handled = false;
        if (!this.guiHidden) {
            handled = this.optionMenuOpen && this.shaderOptionList != null ? this.shaderOptionList.mouseClicked(mouseX, mouseY, mouseButton) : this.shaderPackList.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (!handled) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        boolean handled = false;
        if (!this.guiHidden && state != -1) {
            handled = this.optionMenuOpen && this.shaderOptionList != null ? this.shaderOptionList.mouseReleased(mouseX, mouseY, Mouse.getEventButton()) : this.shaderPackList.mouseReleased(mouseX, mouseY, Mouse.getEventButton());
        }
        if (!handled) {
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l && guiButton instanceof IrisButton) {
            IrisButton irisButton = (IrisButton)guiButton;
            irisButton.onPress();
        }
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController(currentPack.getMenuContainer());
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(currentPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.field_146126_j = this.optionMenuOpen ? I18n.func_135052_a((String)"options.iris.shaderPackList", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.iris.shaderPackSettings", (Object[])new Object[0]);
            this.screenSwitchButton.field_146124_l = this.optionMenuOpen || this.shaderPackList.getTopButtonRow().shadersEnabled;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            if (this.guiHidden) {
                this.guiHidden = false;
                this.func_73866_w_();
                return;
            }
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.func_73866_w_();
                return;
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void displayNotification(String String2) {
        this.notificationDialog = String2;
        this.notificationDialogTimer = 100;
    }

    public void onClose() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.onClose();
    }

    public void applyChanges() {
        ShaderPackEntry entry = this.shaderPackList.getSelected();
        if (entry == null) {
            return;
        }
        this.shaderPackList.setApplied(entry);
        String name = entry.getPackName();
        if (!name.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
        String previousPackName = Iris.getIrisConfig().getShaderPackName().orElse(null);
        boolean previousShadersEnabled = Iris.getIrisConfig().areShadersEnabled();
        if (!name.equals(previousPackName) || enabled != previousShadersEnabled || !Iris.getShaderPackOptionQueue().isEmpty() || Iris.shouldResetShaderPackOptionsOnNextReload()) {
            Iris.getIrisConfig().setShaderPackName(name);
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        }
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        CompletableFuture.runAsync(() -> this.openUri(Iris.getShaderpacksDirectoryManager().getDirectoryUri()));
    }

    private void openUri(URI uri) {
        switch (Util.func_110647_a()) {
            case OSX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case WINDOWS: {
                try {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case LINUX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        boolean openViaSystemClass = false;
        try {
            Class<?> aClass = Class.forName("java.awt.Desktop");
            Object getDesktop = aClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            aClass.getMethod("browse", URI.class).invoke(getDesktop, uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            openViaSystemClass = true;
        }
        if (openViaSystemClass) {
            AngelicaTweaker.LOGGER.debug("Opening via system class!");
            Sys.openURL((String)("file://" + uri));
        }
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> widget, boolean hovered) {
        if (hovered && widget != this.hoveredElement) {
            this.hoveredElement = widget;
            if (widget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)widget).getCommentTitle();
                Optional<String> commentBody = ((CommentedElementWidget)widget).getCommentBody();
                if (!commentBody.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String rawCommentBody = commentBody.get();
                    if (rawCommentBody.endsWith(".")) {
                        rawCommentBody = rawCommentBody.substring(0, rawCommentBody.length() - 1);
                    }
                    List splitByPeriods = Arrays.stream(rawCommentBody.split("\\. [ ]*")).map(String::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<String>();
                    for (String text : splitByPeriods) {
                        this.hoveredElementCommentBody.addAll(this.field_146289_q.func_78271_c(text, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!hovered && widget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.func_73732_a(this.field_146289_q, text, x, y, color);
    }

    public void drawString(String text, int x, int y, int color) {
        this.func_73731_b(this.field_146289_q, text, x, y, color);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

