/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.IterationCounter;
import javax.annotation.Nonnull;

public interface IMEInventory<StackType extends IAEStack> {
    public StackType injectItems(StackType var1, Actionable var2, BaseActionSource var3);

    public StackType extractItems(StackType var1, Actionable var2, BaseActionSource var3);

    @Deprecated
    default public IItemList<StackType> getAvailableItems(IItemList<StackType> out) {
        IItemList<StackType> ret = this.getAvailableItems(out, IterationCounter.incrementGlobalDepth());
        IterationCounter.decrementGlobalDepth();
        return ret;
    }

    default public IItemList<StackType> getAvailableItems(IItemList<StackType> out, int iteration) {
        IterationCounter.incrementGlobalDepthWith(iteration);
        IItemList<StackType> ret = this.getAvailableItems(out);
        IterationCounter.decrementGlobalDepth();
        return ret;
    }

    @Deprecated
    default public StackType getAvailableItem(@Nonnull StackType request) {
        StackType ret = this.getAvailableItem(request, IterationCounter.incrementGlobalDepth());
        IterationCounter.decrementGlobalDepth();
        return ret;
    }

    default public StackType getAvailableItem(@Nonnull StackType request, int iteration) {
        return this.getAvailableItems(this.getChannel().createList(), iteration).findPrecise(request);
    }

    public StorageChannel getChannel();
}

