/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.IPriorityHost;
import appeng.items.materials.ItemMultiMaterial;
import appeng.items.storage.ItemExtremeStorageCell;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.ItemList;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDrive
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost,
IGridTickable {
    private static final int INV_SIZE = 10;
    private static final int STATE_MASK = Integer.MAX_VALUE;
    private static final int STATE_ACTIVE_MASK = 0x40000000;
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final MEInventoryHandler<IAEItemStack>[] invBySlot = new MEInventoryHandler[10];
    private final BaseActionSource mySrc;
    private boolean isCached = false;
    private List<MEInventoryHandler<?>> items = new ArrayList(10);
    private List<MEInventoryHandler<?>> fluids = new ArrayList(10);
    private int state = 0;
    private int type = 0;
    private int priority = 0;
    private boolean wasActive = false;

    public TileDrive() {
        this.mySrc = new MachineSource(this);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileDrive(ByteBuf data) {
        data.writeInt(this.state);
        data.writeInt(this.type);
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 7;
        }
        ItemStack cell = this.inv.func_70301_a(2);
        ICellHandler ch = this.handlersBySlot[slot];
        MEInventoryHandler<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        if (handler.getChannel() == StorageChannel.ITEMS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        if (handler.getChannel() == StorageChannel.FLUIDS && ch != null) {
            return ch.getStatusForCell(cell, handler.getInternal());
        }
        return 0;
    }

    @Override
    public int getCellType(int slot) {
        if (Platform.isClient()) {
            return this.type >> slot * 2 & 3;
        }
        MEInventoryHandler<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        IMEInventory<IAEItemStack> iMEInventory = handler.getInternal();
        if (iMEInventory instanceof ICellCacheRegistry) {
            ICellCacheRegistry iccr = (ICellCacheRegistry)((Object)iMEInventory);
            switch (iccr.getCellType()) {
                case ITEM: {
                    return 0;
                }
                case FLUID: {
                    return 1;
                }
                case ESSENTIA: {
                    return 2;
                }
            }
        }
        return 0;
    }

    public MEInventoryHandler<IAEItemStack> getCellInvBySlot(int slot) {
        return this.invBySlot[slot];
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(15, 15, false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.recalculateDisplay();
        return TickRateModulation.SAME;
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.state & 0x40000000) == 0x40000000;
        }
        return this.getProxy().isActive();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileDrive(ByteBuf data) {
        int oldState = this.state;
        int oldType = this.type;
        this.state = data.readInt() & Integer.MAX_VALUE;
        this.type = data.readInt();
        return this.state != oldState || this.type != oldType;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileDrive(NBTTagCompound data) {
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileDrive(NBTTagCompound data) {
        data.func_74768_a("priority", this.priority);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        int newState = 0;
        int newType = 0;
        boolean currentActive = this.getProxy().isActive();
        if (currentActive) {
            newState |= 0x40000000;
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= (this.getCellStatus(x) & 7) << 3 * x;
            newType |= (this.getCellType(x) & 3) << 2 * x;
        }
        if (this.state != newState || this.type != newType) {
            this.markForUpdate();
            this.state = newState;
            this.type = newType;
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack != null && AEApi.instance().registries().cell().isCellHandled(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges(gs, removed, added, this.mySrc);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    private void updateState() {
        if (!this.isCached) {
            this.items = new ArrayList(10);
            this.fluids = new ArrayList(10);
            double power = 2.0;
            for (int x = 0; x < this.inv.func_70302_i_(); ++x) {
                MEInventoryHandler ih;
                ItemStack is = this.inv.func_70301_a(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is == null) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                IMEInventoryHandler cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.ITEMS);
                if (cell != null) {
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    ih = new MEInventoryHandler(cell, cell.getChannel());
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.items.add(ih);
                    continue;
                }
                cell = this.handlersBySlot[x].getCellInventory(is, this, StorageChannel.FLUIDS);
                if (cell == null) continue;
                power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                ih = new MEInventoryHandler(cell, cell.getChannel());
                ih.setPriority(this.priority);
                this.invBySlot[x] = ih;
                this.fluids.add(ih);
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return channel == StorageChannel.ITEMS ? this.items : this.fluids;
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.func_70296_d();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public static void partitionDigitalSingularityCellToItemOnCell(ICellInventoryHandler handler) {
        ICellInventory cellInventory = handler.getCellInv();
        if (cellInventory != null && cellInventory.getStoredItemTypes() != 0L) {
            ItemStack partition = handler.getAvailableItems(new ItemList(), IterationCounter.fetchNewId()).getFirstItem().getItemStack().func_77946_l();
            partition.field_77994_a = 1;
            cellInventory.getConfigInventory().func_70299_a(0, partition);
        }
    }

    public static boolean applyStickyCardToDigitalSingularityCell(ICellHandler cellHandler, ItemStack cell, ISaveProvider host, ICellWorkbenchItem cellItem) {
        ICellInventoryHandler handler;
        ICellInventory cellInventory;
        IMEInventoryHandler inv = cellHandler.getCellInventory(cell, host, StorageChannel.ITEMS);
        if (inv instanceof ICellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inv).getCellInv()) != null && cellInventory.getStoredItemTypes() == 1L) {
            IInventory cellUpgrades = cellItem.getUpgradesInventory(cell);
            int freeSlot = -1;
            for (int i = 0; i < cellUpgrades.func_70302_i_(); ++i) {
                if (freeSlot == -1 && cellUpgrades.func_70301_a(i) == null) {
                    freeSlot = i;
                    continue;
                }
                if (cellUpgrades.func_70301_a(i) == null || ItemMultiMaterial.instance.getType(cellUpgrades.func_70301_a(i)) != Upgrades.STICKY) continue;
                freeSlot = -1;
                break;
            }
            if (freeSlot != -1) {
                Optional<ItemStack> stickyCard = AEApi.instance().definitions().materials().cardSticky().maybeStack(1);
                if (stickyCard.isPresent()) {
                    cellUpgrades.func_70299_a(freeSlot, (ItemStack)stickyCard.get());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean lockDigitalSingularityCells() {
        boolean res = false;
        for (int i = 0; i < this.handlersBySlot.length; ++i) {
            IMEInventoryHandler inv;
            ICellHandler cellHandler = this.handlersBySlot[i];
            ItemStack cell = this.inv.func_70301_a(i);
            if (ItemExtremeStorageCell.checkInvalidForLockingAndStickyCarding(cell, cellHandler) || !((inv = cellHandler.getCellInventory(cell, this, StorageChannel.ITEMS)) instanceof ICellInventoryHandler)) continue;
            ICellInventoryHandler handler = (ICellInventoryHandler)inv;
            TileDrive.partitionDigitalSingularityCellToItemOnCell(handler);
            res = true;
        }
        return res;
    }

    @Override
    public int applyStickyToDigitalSingularityCells(ItemStack cards) {
        int res = 0;
        for (int i = 0; i < this.handlersBySlot.length; ++i) {
            Item item;
            ICellHandler cellHandler = this.handlersBySlot[i];
            ItemStack cell = this.inv.func_70301_a(i);
            if (ItemExtremeStorageCell.checkInvalidForLockingAndStickyCarding(cell, cellHandler) || !((item = cell.func_77973_b()) instanceof ICellWorkbenchItem)) continue;
            ICellWorkbenchItem cellItem = (ICellWorkbenchItem)item;
            if (res + 1 > cards.field_77994_a || !TileDrive.applyStickyCardToDigitalSingularityCell(cellHandler, cell, this, cellItem)) continue;
            ++res;
        }
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return res;
    }
}

