/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Queue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EmbeddedChannel.class})
public abstract class MixinEmbeddedChannel
extends AbstractChannel {
    @Shadow
    private Throwable lastException;
    private Queue<AbstractMap.SimpleEntry<Object, ChannelPromise>> tempInboundMessages;

    protected MixinEmbeddedChannel(Channel parent) {
        super(parent);
    }

    @Shadow
    public abstract ChannelConfig config();

    private Queue<AbstractMap.SimpleEntry<Object, ChannelPromise>> tempInboundMessages() {
        if (this.tempInboundMessages == null) {
            this.tempInboundMessages = new ArrayDeque<AbstractMap.SimpleEntry<Object, ChannelPromise>>();
        }
        return this.tempInboundMessages;
    }

    @Inject(method={"writeInbound"}, at={@At(value="INVOKE", target="Lio/netty/channel/embedded/EmbeddedChannel;pipeline()Lio/netty/channel/ChannelPipeline;")}, cancellable=true, remap=false)
    private void storeMsgs(Object[] msgs, CallbackInfoReturnable<Boolean> cir) {
        if (!this.config().isAutoRead()) {
            Queue<AbstractMap.SimpleEntry<Object, ChannelPromise>> tempInboundMessages = this.tempInboundMessages();
            for (Object msg : msgs) {
                tempInboundMessages.add(new AbstractMap.SimpleEntry<Object, Object>(msg, null));
            }
            cir.setReturnValue((Object)false);
        }
    }

    private static boolean isNotEmpty(Queue<?> queue) {
        return queue != null && !queue.isEmpty();
    }

    @Inject(method={"doClose"}, at={@At(value="RETURN")}, remap=false)
    private void handleInboundClosing(CallbackInfo ci) {
        if (MixinEmbeddedChannel.isNotEmpty(this.tempInboundMessages)) {
            AbstractMap.SimpleEntry<Object, ChannelPromise> entry;
            ClosedChannelException exception = null;
            while ((entry = this.tempInboundMessages.poll()) != null) {
                ChannelPromise promise;
                Object value = entry.getKey();
                if (value != null) {
                    ReferenceCountUtil.release((Object)value);
                }
                if ((promise = entry.getValue()) == null) continue;
                if (exception == null) {
                    exception = new ClosedChannelException();
                }
                promise.tryFailure(exception);
            }
        }
    }

    private ChannelFuture checkException(ChannelPromise promise) {
        Throwable t = this.lastException;
        if (t != null) {
            this.lastException = null;
            return promise.setFailure(t);
        }
        return promise.setSuccess();
    }

    @Inject(method={"doBeginRead"}, at={@At(value="HEAD")}, remap=false)
    private void readTmpInbounds(CallbackInfo ci) {
        if (MixinEmbeddedChannel.isNotEmpty(this.tempInboundMessages)) {
            AbstractMap.SimpleEntry<Object, ChannelPromise> pair;
            while ((pair = this.tempInboundMessages.poll()) != null) {
                ChannelPromise promise;
                Object msg = pair.getKey();
                if (msg != null) {
                    this.pipeline().fireChannelRead(msg);
                }
                if ((promise = pair.getValue()) == null) continue;
                this.checkException(promise);
            }
            this.flush();
        }
    }
}

