/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IValidatedTankContainer;
import binnie.core.machines.power.ITankMachine;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TransferHandler {
    public static ItemStack transfer(ItemStack item, IInventory origin, IInventory destination, boolean doAdd) {
        ItemStack ret = TransferHandler.transferItemToInventory(item, destination, doAdd);
        if (destination instanceof ITankMachine) {
            ret = TransferHandler.transferContainerIntoTank(ret, origin, (ITankMachine)destination, doAdd);
            ret = TransferHandler.transferTankIntoContainer(ret, origin, (ITankMachine)destination, doAdd);
        }
        return ret;
    }

    public static ItemStack transferItemToInventory(ItemStack item, IInventory destination, boolean doAdd) {
        if (item == null || destination == null) {
            return item;
        }
        ItemStack addition = item.func_77946_l();
        int i = 0;
        while (i < destination.func_70302_i_()) {
            if ((addition = TransferHandler.transferToInventory(addition, destination, new int[]{i++}, doAdd, false)) != null) continue;
            return null;
        }
        return addition;
    }

    public static ItemStack transferToInventory(ItemStack item, IInventory destination, int[] targetSlots, boolean doAdd, boolean ignoreValidation) {
        for (int i : targetSlots) {
            if (!destination.func_94041_b(i, item) && !ignoreValidation) continue;
            if (destination.func_70301_a(i) == null) {
                if (doAdd) {
                    destination.func_70299_a(i, item.func_77946_l());
                }
                return null;
            }
            if (!item.func_77985_e()) continue;
            ItemStack merged = destination.func_70301_a(i).func_77946_l();
            ItemStack[] newStacks = TransferHandler.mergeStacks(item.func_77946_l(), merged.func_77946_l());
            item = newStacks[0];
            if (doAdd) {
                destination.func_70299_a(i, newStacks[1]);
            }
            if (item != null) continue;
            return null;
        }
        return item;
    }

    public static ItemStack[] mergeStacks(ItemStack itemstack, ItemStack merged) {
        int space;
        if (ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)merged) && itemstack.func_77969_a(merged) && (space = merged.func_77976_d() - merged.field_77994_a) > 0) {
            if (itemstack.field_77994_a > space) {
                itemstack.field_77994_a -= space;
                merged.field_77994_a += space;
            } else {
                merged.field_77994_a += itemstack.field_77994_a;
                itemstack = null;
            }
        }
        return new ItemStack[]{itemstack, merged};
    }

    public static ItemStack transferContainerIntoTank(ItemStack item, IInventory origin, ITankMachine destination, boolean doAdd) {
        if (item == null) {
            return null;
        }
        IFluidTank[] tanks = destination.getTanks();
        ItemStack stack = item.func_77946_l();
        for (int i = 0; i < tanks.length; ++i) {
            stack = TransferHandler.transferToTank(stack, origin, destination, i, doAdd);
        }
        return stack;
    }

    public static ItemStack transferTankIntoContainer(ItemStack item, IInventory origin, ITankMachine destination, boolean doAdd) {
        if (item == null) {
            return null;
        }
        IFluidTank[] tanks = destination.getTanks();
        ItemStack stack = item.func_77946_l();
        for (int i = 0; i < tanks.length; ++i) {
            stack = TransferHandler.transferFromTank(stack, origin, destination, i, doAdd);
        }
        return stack;
    }

    public static ItemStack transferToTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        ItemStack containersThatCantBeDumped;
        ItemStack copy;
        if (item == null) {
            return item;
        }
        FluidStack containerLiquid = null;
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.filledContainer.func_77969_a(item)) continue;
            containerLiquidData = data;
            containerLiquid = data.fluid.copy();
            break;
        }
        if (containerLiquid == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        IValidatedTankContainer validated = Machine.getInterface(IValidatedTankContainer.class, destination);
        if (validated != null && !validated.isLiquidValidForTank(containerLiquid, tankID)) {
            return item;
        }
        FluidStack largeAmountOfLiquid = containerLiquid.copy();
        largeAmountOfLiquid.amount = tank.getCapacity();
        int amountAdded = tank.fill(largeAmountOfLiquid, false);
        int numberOfContainersToAdd = amountAdded / containerLiquid.amount;
        if (numberOfContainersToAdd > item.field_77994_a) {
            numberOfContainersToAdd = item.field_77994_a;
        }
        ItemStack leftOverContainers = copy = item.func_77946_l();
        copy.field_77994_a -= numberOfContainersToAdd;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack emptyContainers = containerLiquidData.emptyContainer.func_77946_l();
        emptyContainers.field_77994_a = 0;
        ItemStack itemStack = emptyContainers;
        itemStack.field_77994_a += numberOfContainersToAdd;
        if (emptyContainers.field_77994_a <= 0) {
            emptyContainers = null;
        }
        if ((containersThatCantBeDumped = TransferHandler.transferItemToInventory(emptyContainers, origin, false)) != null) {
            return item;
        }
        if (doAdd) {
            FluidStack copy2;
            FluidStack liquidToFillTank = copy2 = containerLiquid.copy();
            copy2.amount *= numberOfContainersToAdd;
            tank.fill(liquidToFillTank, true);
            TransferHandler.transferItemToInventory(emptyContainers, origin, true);
        }
        return leftOverContainers;
    }

    public static ItemStack transferFromTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        ItemStack containersThatCantBeDumped;
        ItemStack copy;
        if (item == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        FluidStack liquidInTank = tank.getFluid();
        if (liquidInTank == null) {
            return item;
        }
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.emptyContainer.func_77969_a(item) || !liquidInTank.isFluidEqual(data.fluid)) continue;
            containerLiquidData = data;
            break;
        }
        if (containerLiquidData == null) {
            return item;
        }
        int maximumExtractedLiquid = item.field_77994_a * containerLiquidData.fluid.amount;
        FluidStack drainedLiquid = tank.drain(maximumExtractedLiquid, false);
        int amountInTank = drainedLiquid == null ? 0 : drainedLiquid.amount;
        int numberOfContainersToFill = amountInTank / containerLiquidData.fluid.amount;
        if (numberOfContainersToFill > item.field_77994_a) {
            numberOfContainersToFill = item.field_77994_a;
        }
        ItemStack leftOverContainers = copy = item.func_77946_l();
        copy.field_77994_a -= numberOfContainersToFill;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack filledContainers = containerLiquidData.filledContainer.func_77946_l();
        filledContainers.field_77994_a = 0;
        ItemStack itemStack = filledContainers;
        itemStack.field_77994_a += numberOfContainersToFill;
        if (filledContainers.field_77994_a <= 0) {
            filledContainers = null;
        }
        if ((containersThatCantBeDumped = TransferHandler.transferItemToInventory(filledContainers, origin, false)) != null) {
            return item;
        }
        if (doAdd) {
            tank.drain(maximumExtractedLiquid, true);
            TransferHandler.transferItemToInventory(filledContainers, origin, true);
        }
        return leftOverContainers;
    }
}

