/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.genepool;

import binnie.Binnie;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.item.GeneticLiquid;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.item.ItemStack;

public class GenepoolComponentLogic
extends ComponentProcessSetCost
implements IProcess,
INetwork.TilePacketSync {
    private float ethanolDrain = 0.0f;

    public GenepoolComponentLogic(Machine machine) {
        super(machine, 8000, 400);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.genepool.error.noIndividual"), 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().spaceInTank(0, this.getDNAAmount(this.getUtil().getStack(0)))) {
            return new ErrorState.NoSpace(I18N.localise("genetics.machine.genepool.error.noRoom"), 0);
        }
        if (!this.getUtil().liquidInTank(1, 1)) {
            return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.genepool.error.noEthanol"), 1);
        }
        if (this.getUtil().getSlotCharge(7) == 0.0f) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.genepool.error.insufficientEnzyme"), 7);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        int amount = this.getDNAAmount(this.getUtil().getStack(0));
        this.getUtil().fillTank(0, GeneticLiquid.RawDNA.get(amount));
        this.getUtil().deleteStack(0);
    }

    private int getDNAAmount(ItemStack stack) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root == null || root != Binnie.Genetics.getBeeRoot() || Binnie.Genetics.getBeeRoot().isDrone(stack)) {
            return 10;
        }
        if (Binnie.Genetics.getBeeRoot().isMated(stack)) {
            return 50;
        }
        return 30;
    }

    @Override
    protected void onTickTask() {
        this.ethanolDrain += (float)this.getDNAAmount(this.getUtil().getStack(0)) * 1.2f * this.getProgressPerTick() / 100.0f;
        if (this.ethanolDrain >= 1.0f) {
            this.getUtil().drainTank(1, 1);
            this.ethanolDrain -= 1.0f;
        }
        this.getMachine().getInterface(IChargedSlots.class).alterCharge(7, -0.25f * this.getProgressPerTick() / 100.0f);
    }
}

